/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import java.util.function.Supplier;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.gamedata.Animations;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCLivingMotionChange {
    private int entityId;
    private int count;
    private LivingMotion[] motion;
    private StaticAnimation[] animation;

    public STCLivingMotionChange() {
        this.entityId = 0;
        this.count = 0;
    }

    public STCLivingMotionChange(int entityId, int count) {
        this.entityId = entityId;
        this.count = count;
        this.motion = new LivingMotion[0];
        this.animation = new StaticAnimation[0];
    }

    public void setAnimations(StaticAnimation ... animation) {
        this.animation = animation;
    }

    public void setMotions(LivingMotion ... motion) {
        this.motion = motion;
    }

    public LivingMotion[] getMotions() {
        return this.motion;
    }

    public StaticAnimation[] getAnimations() {
        return this.animation;
    }

    public static STCLivingMotionChange fromBytes(PacketBuffer buf) {
        int i;
        STCLivingMotionChange msg = new STCLivingMotionChange(buf.readInt(), buf.readInt());
        LivingMotion[] motionarr = new LivingMotion[msg.count];
        StaticAnimation[] idarr = new StaticAnimation[msg.count];
        for (i = 0; i < msg.count; ++i) {
            motionarr[i] = LivingMotion.values()[buf.readInt()];
        }
        for (i = 0; i < msg.count; ++i) {
            idarr[i] = Animations.findAnimationDataById(buf.readInt());
        }
        msg.motion = motionarr;
        msg.animation = idarr;
        return msg;
    }

    public static void toBytes(STCLivingMotionChange msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.count);
        for (LivingMotion livingMotion : msg.motion) {
            buf.writeInt(livingMotion.getId());
        }
        for (StaticAnimation staticAnimation : msg.animation) {
            buf.writeInt(staticAnimation.getId());
        }
    }

    public static void handle(STCLivingMotionChange msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId);
            if (entity != null) {
                LivingData entitydata = (LivingData)entity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                AnimatorClient animator = entitydata.getClientAnimator();
                animator.resetMixMotion();
                animator.offMixLayer(false);
                animator.resetModifiedLivingMotions();
                for (int i = 0; i < msg.count; ++i) {
                    entitydata.getClientAnimator().addModifiedLivingMotion(msg.motion[i], msg.animation[i]);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

