/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCModifySkillVariable {
    private String nbtName;
    private Object value;
    private int index;
    private int type;

    public STCModifySkillVariable() {
        this.nbtName = "";
        this.value = null;
    }

    public STCModifySkillVariable(VariableType type, SkillSlot slot, String nbtName, Object value) {
        this(type.id, slot.getIndex(), nbtName, value);
    }

    public STCModifySkillVariable(int type, int slot, String nbtName, Object value) {
        this.type = type;
        this.index = slot;
        this.nbtName = nbtName;
        this.value = value;
    }

    public static STCModifySkillVariable fromBytes(PacketBuffer buf) {
        Comparable<Boolean> value = null;
        int type = buf.readInt();
        switch (type) {
            case 0: {
                value = buf.readBoolean();
                break;
            }
            case 1: {
                value = buf.readInt();
                break;
            }
            case 2: {
                value = Float.valueOf(buf.readFloat());
                break;
            }
        }
        return new STCModifySkillVariable(type, buf.readInt(), buf.func_218666_n(), (Object)value);
    }

    public static void toBytes(STCModifySkillVariable msg, PacketBuffer buf) {
        buf.writeInt(msg.type);
        switch (msg.type) {
            case 0: {
                buf.writeBoolean(((Boolean)msg.value).booleanValue());
                break;
            }
            case 1: {
                buf.writeInt(((Integer)msg.value).intValue());
                break;
            }
            case 2: {
                buf.writeFloat(((Float)msg.value).floatValue());
                break;
            }
        }
        buf.writeInt(msg.index);
        buf.func_180714_a(msg.nbtName);
    }

    public static void handle(STCModifySkillVariable msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientPlayerData playerdata = (ClientPlayerData)Minecraft.func_71410_x().field_71439_g.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            if (playerdata != null) {
                CompoundNBT nbt = playerdata.getSkill(msg.index).getVariableNBT();
                switch (msg.type) {
                    case 0: {
                        nbt.func_74757_a(msg.nbtName, ((Boolean)msg.value).booleanValue());
                        break;
                    }
                    case 1: {
                        nbt.func_74768_a(msg.nbtName, ((Integer)msg.value).intValue());
                        break;
                    }
                    case 2: {
                        nbt.func_74776_a(msg.nbtName, ((Float)msg.value).floatValue());
                        break;
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum VariableType {
        BOOLEAN(0),
        INTEGER(1),
        FLOAT(2);

        final int id;

        private VariableType(int id) {
            this.id = id;
        }
    }
}

