/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public abstract class Collider {
    protected final Vec3f modelCenter;
    protected AxisAlignedBB hitboxAABB;
    protected Vec3f worldCenter;

    public Collider(Vec3f pos, @Nullable AxisAlignedBB entityCallAABB) {
        this.modelCenter = pos;
        this.hitboxAABB = entityCallAABB;
        this.worldCenter = new Vec3f();
    }

    public void transform(Mat4f mat) {
        Vec4f temp = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        temp.x = this.modelCenter.x;
        temp.y = this.modelCenter.y;
        temp.z = this.modelCenter.z;
        Mat4f.transform(mat, temp, temp);
        this.worldCenter.x = temp.x;
        this.worldCenter.y = temp.y;
        this.worldCenter.z = temp.z;
    }

    public abstract FloatBuffer getVertexBuffer();

    public abstract boolean isCollideWith(Entity var1);

    public void extractHitEntities(List<Entity> entities) {
        Iterator<Entity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (this.isCollideWith(entity)) continue;
            iterator.remove();
        }
    }

    public Vec3d getCenter() {
        return new Vec3d((double)this.worldCenter.x, (double)this.worldCenter.y, (double)this.worldCenter.z);
    }

    public AxisAlignedBB getHitboxAABB() {
        return this.hitboxAABB.func_72317_d((double)(-this.worldCenter.x), (double)this.worldCenter.y, (double)(-this.worldCenter.z));
    }
}

