/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import java.nio.FloatBuffer;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColliderOBB
extends Collider {
    private final Vec3f[] modelVertex;
    private final Vec3f[] modelNormal;
    private final boolean is3D;
    private Vec3f[] rotatedVertex;
    private Vec3f[] rotatedNormal;

    public ColliderOBB(float posX, float posY, float posZ, float center_x, float center_y, float center_z) {
        super(new Vec3f(center_x, center_y, center_z), null);
        float xLength = Math.abs(posX - center_x);
        float yLength = Math.abs(posY - center_y);
        float zLength = Math.abs(posZ - center_z);
        float maxLength = Math.max(xLength, Math.max(yLength, zLength));
        this.hitboxAABB = new AxisAlignedBB((double)maxLength, (double)maxLength, (double)maxLength, (double)(-maxLength), (double)(-maxLength), (double)(-maxLength));
        this.modelVertex = new Vec3f[4];
        this.modelNormal = new Vec3f[3];
        this.rotatedVertex = new Vec3f[4];
        this.rotatedNormal = new Vec3f[3];
        this.modelVertex[0] = new Vec3f(posX, posY, -posZ);
        this.modelVertex[1] = new Vec3f(posX, posY, posZ);
        this.modelVertex[2] = new Vec3f(-posX, posY, posZ);
        this.modelVertex[3] = new Vec3f(-posX, posY, -posZ);
        this.modelNormal[0] = new Vec3f(1.0f, 0.0f, 0.0f);
        this.modelNormal[1] = new Vec3f(0.0f, 1.0f, 0.0f);
        this.modelNormal[2] = new Vec3f(0.0f, 0.0f, -1.0f);
        this.rotatedVertex[0] = new Vec3f();
        this.rotatedVertex[1] = new Vec3f();
        this.rotatedVertex[2] = new Vec3f();
        this.rotatedVertex[3] = new Vec3f();
        this.rotatedNormal[0] = new Vec3f();
        this.rotatedNormal[1] = new Vec3f();
        this.rotatedNormal[2] = new Vec3f();
        this.is3D = true;
    }

    public ColliderOBB(AxisAlignedBB entityCallAABB, float pos1_x, float pos1_y, float pos1_z, float pos2_x, float pos2_y, float pos2_z, float norm1_x, float norm1_y, float norm1_z, float norm2_x, float norm2_y, float norm2_z, float center_x, float center_y, float center_z) {
        super(new Vec3f(center_x, center_y, center_z), entityCallAABB);
        this.modelVertex = new Vec3f[2];
        this.modelNormal = new Vec3f[2];
        this.rotatedVertex = new Vec3f[2];
        this.rotatedNormal = new Vec3f[2];
        this.modelVertex[0] = new Vec3f(pos1_x, pos1_y, pos1_z);
        this.modelVertex[1] = new Vec3f(pos2_x, pos2_y, pos2_z);
        this.modelNormal[0] = new Vec3f(norm1_x, norm1_y, norm1_z);
        this.modelNormal[1] = new Vec3f(norm2_x, norm2_y, norm2_z);
        this.rotatedVertex[0] = new Vec3f();
        this.rotatedVertex[1] = new Vec3f();
        this.rotatedNormal[0] = new Vec3f();
        this.rotatedNormal[1] = new Vec3f();
        this.is3D = false;
    }

    public ColliderOBB(AxisAlignedBB aabbCopy) {
        super(null, null);
        this.modelVertex = null;
        this.modelNormal = null;
        float xSize = (float)(aabbCopy.field_72336_d - aabbCopy.field_72340_a) / 2.0f;
        float ySize = (float)(aabbCopy.field_72337_e - aabbCopy.field_72338_b) / 2.0f;
        float zSize = (float)(aabbCopy.field_72334_f - aabbCopy.field_72339_c) / 2.0f;
        this.worldCenter = new Vec3f(-((float)aabbCopy.field_72340_a + xSize), (float)aabbCopy.field_72338_b + ySize, -((float)aabbCopy.field_72339_c + zSize));
        this.rotatedVertex = new Vec3f[4];
        this.rotatedNormal = new Vec3f[3];
        this.rotatedVertex[0] = new Vec3f(-xSize, ySize, -zSize);
        this.rotatedVertex[1] = new Vec3f(-xSize, ySize, zSize);
        this.rotatedVertex[2] = new Vec3f(xSize, ySize, zSize);
        this.rotatedVertex[3] = new Vec3f(xSize, ySize, -zSize);
        this.rotatedNormal[0] = new Vec3f(1.0f, 0.0f, 0.0f);
        this.rotatedNormal[1] = new Vec3f(0.0f, 1.0f, 0.0f);
        this.rotatedNormal[2] = new Vec3f(0.0f, 0.0f, 1.0f);
        this.is3D = true;
    }

    @Override
    public void transform(Mat4f mat) {
        int i;
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        Mat4f rotationMatrix = new Mat4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        for (i = 0; i < this.modelVertex.length; ++i) {
            tempVector.x = this.modelVertex[i].x;
            tempVector.y = this.modelVertex[i].y;
            tempVector.z = this.modelVertex[i].z;
            Mat4f.transform(rotationMatrix, tempVector, tempVector);
            this.rotatedVertex[i].x = tempVector.x;
            this.rotatedVertex[i].y = tempVector.y;
            this.rotatedVertex[i].z = tempVector.z;
        }
        for (i = 0; i < this.modelNormal.length; ++i) {
            tempVector.x = this.modelNormal[i].x;
            tempVector.y = this.modelNormal[i].y;
            tempVector.z = this.modelNormal[i].z;
            Mat4f.transform(rotationMatrix, tempVector, tempVector);
            this.rotatedNormal[i].x = tempVector.x;
            this.rotatedNormal[i].y = tempVector.y;
            this.rotatedNormal[i].z = tempVector.z;
        }
        super.transform(mat);
    }

    public boolean isCollideWith(ColliderOBB opponent) {
        Vec3f toOpponent = Vec3f.sub(opponent.worldCenter, this.worldCenter, null);
        for (Vec3f seperateAxis : this.rotatedNormal) {
            if (ColliderOBB.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        for (Vec3f seperateAxis : opponent.rotatedNormal) {
            if (ColliderOBB.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        ColliderOBB obb = new ColliderOBB(entity.func_174813_aQ());
        return this.isCollideWith(obb);
    }

    private static boolean collisionDetection(Vec3f seperateAxis, Vec3f toOpponent, ColliderOBB box1, ColliderOBB box2) {
        float dot;
        Vec3f temp;
        Vec3f maxProj1 = null;
        Vec3f maxProj2 = null;
        float maxDot1 = -1.0f;
        float maxDot2 = -1.0f;
        Vec3f distance = Vec3f.dot(seperateAxis, toOpponent) > 0.0f ? toOpponent : new Vec3f(-toOpponent.x, -toOpponent.y, -toOpponent.z);
        for (Vec3f vertexVector : box1.rotatedVertex) {
            temp = Vec3f.dot(seperateAxis, vertexVector) > 0.0f ? vertexVector : new Vec3f(-vertexVector.x, -vertexVector.y, -vertexVector.z);
            dot = Vec3f.dot(seperateAxis, temp);
            if (!(dot > maxDot1)) continue;
            maxDot1 = dot;
            maxProj1 = temp;
        }
        for (Vec3f vertexVector : box2.rotatedVertex) {
            temp = Vec3f.dot(seperateAxis, vertexVector) > 0.0f ? vertexVector : new Vec3f(-vertexVector.x, -vertexVector.y, -vertexVector.z);
            dot = Vec3f.dot(seperateAxis, temp);
            if (!(dot > maxDot2)) continue;
            maxDot2 = dot;
            maxProj2 = temp;
        }
        return !(ColliderOBB.getProjectedScale(seperateAxis, distance) >= ColliderOBB.getProjectedScale(seperateAxis, maxProj1) + ColliderOBB.getProjectedScale(seperateAxis, maxProj2));
    }

    private static float getProjectedScale(Vec3f normal, Vec3f projecting) {
        float dot = Vec3f.dot(normal, projecting);
        float normalScale = 1.0f / (normal.x * normal.x + normal.y * normal.y + normal.z * normal.z);
        Vec3f projVec = new Vec3f(dot * normal.x * normalScale, dot * normal.y * normalScale, dot * normal.z * normalScale);
        return (float)Math.sqrt(projVec.x * projVec.x + projVec.y * projVec.y + projVec.z * projVec.z);
    }

    public boolean is3d() {
        return this.is3D;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public FloatBuffer getVertexBuffer() {
        FloatBuffer buf = GLAllocation.func_74529_h((int)24);
        for (Vec3f vector : this.rotatedVertex) {
            Vec3f pos1 = Vec3f.add(this.worldCenter, vector, null);
            buf.put(pos1.x);
            buf.put(pos1.y);
            buf.put(pos1.z);
        }
        for (Vec3f vector : this.rotatedVertex) {
            Vec3f pos2 = Vec3f.sub(this.worldCenter, vector, null);
            buf.put(pos2.x);
            buf.put(pos2.y);
            buf.put(pos2.z);
        }
        buf.flip();
        return buf;
    }
}

