/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.skill.Skill;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillContainer {
    protected Skill containingSkill;
    protected PlayerData<?> executer;
    protected int prevDuration = 0;
    protected int duration = 0;
    protected float cooldown = 0.0f;
    protected float prevCooldown = 0.0f;
    protected boolean isActivated = false;
    protected boolean consumeDuration;
    protected int stack;
    protected CompoundNBT skillVariables;

    public SkillContainer(PlayerData<?> executer) {
        this.executer = executer;
        this.skillVariables = new CompoundNBT();
    }

    public void setExecuter(PlayerData<?> executer) {
        this.executer = executer;
    }

    public SkillContainer setSkill(Skill skill) {
        if (this.containingSkill != null) {
            this.containingSkill.onDeleted(this);
        }
        this.containingSkill = skill;
        if (skill != null) {
            skill.onInitiate(this);
        }
        this.reset(false);
        this.stack = 0;
        for (String key : this.skillVariables.func_150296_c()) {
            this.skillVariables.func_82580_o(key);
        }
        return this;
    }

    public void reset(boolean consume) {
        if (consume && this.stack > 0) {
            --this.stack;
        }
        this.isActivated = false;
        this.consumeDuration = true;
        this.prevDuration = 0;
        this.duration = 0;
        if (this.getContaining() != null && this.getContaining().maxStackSize <= 1) {
            this.prevCooldown = 0.0f;
            this.cooldown = 0.0f;
            this.containingSkill.onReset(this);
        }
    }

    public boolean isEmpty() {
        return this.containingSkill == null;
    }

    public void setCooldown(float value) {
        if (this.containingSkill != null) {
            this.containingSkill.setCooldown(this, value);
        } else {
            this.prevCooldown = 0.0f;
            this.cooldown = 0.0f;
        }
    }

    public void setDuration(int value) {
        if (this.containingSkill != null) {
            if (!this.isActivated && value > 0) {
                this.isActivated = true;
            }
            this.duration = value;
            this.duration = Math.min(this.containingSkill.duration, Math.max(this.duration, 0));
        } else {
            this.duration = 0;
        }
    }

    public void setDurationConsume(boolean set) {
        this.consumeDuration = set;
    }

    public void setCooldownPercent(float value) {
        this.setCooldown(this.containingSkill.cooldown * value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void execute(ClientPlayerData executer) {
        if (this.canExecute(executer)) {
            this.containingSkill.executeOnClient(executer, this.containingSkill.gatherArguments(executer, ClientEngine.INSTANCE.inputController));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void cancel(ClientPlayerData executer, PacketBuffer pb) {
        this.containingSkill.cancelOnClient(executer, pb);
    }

    public boolean requestExecute(ServerPlayerData executer, PacketBuffer buf) {
        if (this.canExecute(executer)) {
            this.containingSkill.execute(this);
            this.containingSkill.executeOnServer(executer, buf);
            return true;
        }
        return false;
    }

    public CompoundNBT getVariableNBT() {
        return this.skillVariables;
    }

    public float getRemainCooldown() {
        return this.cooldown;
    }

    public int getRemainDuration() {
        return this.duration;
    }

    public boolean canExecute(PlayerData<?> executer) {
        if (this.containingSkill == null) {
            return false;
        }
        return (this.stack > 0 || ((PlayerEntity)executer.getOriginalEntity()).func_184812_l_()) && this.containingSkill.canExecute(executer);
    }

    public void update() {
        if (this.containingSkill != null) {
            this.containingSkill.update(this);
        }
    }

    public int getStack() {
        return this.stack;
    }

    public Skill getContaining() {
        return this.containingSkill;
    }

    public float getCooldownRatio() {
        return this.containingSkill != null && this.containingSkill.cooldown > 0.0f ? (this.prevCooldown + (this.cooldown - this.prevCooldown) * ClientEngine.INSTANCE.renderEngine.getPartialTicks()) / this.containingSkill.cooldown : 0.0f;
    }

    public float getCooldownSec() {
        return this.containingSkill != null ? this.containingSkill.cooldown - this.cooldown : 0.0f;
    }

    public float getDurationRatio() {
        return this.containingSkill != null && this.containingSkill.duration > 0 ? ((float)this.prevDuration + (float)(this.duration - this.prevDuration) * ClientEngine.INSTANCE.renderEngine.getPartialTicks()) / (float)this.containingSkill.duration : 0.0f;
    }
}

