/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSExecuteSkill;
import maninhouse.epicfight.network.server.STCResetBasicAttackCool;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class SpecialAttackSkill
extends Skill {
    protected final StaticAnimation attackAnimation;

    public SpecialAttackSkill(SkillSlot index, float restriction, ResourceLocation textureLocation, StaticAnimation animation) {
        super(index, restriction, textureLocation);
        this.attackAnimation = animation;
    }

    public SpecialAttackSkill(SkillSlot index, float restriction, int duration, ResourceLocation textureLocation, StaticAnimation animation) {
        super(index, restriction, duration, true, textureLocation);
        this.attackAnimation = animation;
    }

    @Override
    public void executeOnClient(ClientPlayerData executer, PacketBuffer args) {
        ModNetworkManager.sendToServer(new CTSExecuteSkill(this.slot.getIndex(), true, args));
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.playAnimationSynchronize(this.attackAnimation, 0.0f);
        ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
    }

    @Override
    public float getRegenTimePerTick(PlayerData<?> player) {
        return 0.0f;
    }

    @Override
    public boolean canExecute(PlayerData<?> executer) {
        CapabilityItem item = executer.getHeldItemCapability(Hand.MAIN_HAND);
        if (item != null) {
            Skill skill = item.getSpecialAttack(((PlayerEntity)executer.getOriginalEntity()).func_184592_cb());
            return skill == this && ((PlayerEntity)executer.getOriginalEntity()).func_184187_bx() == null;
        }
        return false;
    }
}

