/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.utils.game;

import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.EntityDamageSource;

public class DamageSourceExtended
extends EntityDamageSource
implements IExtendedDamageSource {
    private float impact;
    private float armorIgnore;
    private boolean isSureStrike;
    private IExtendedDamageSource.StunType stunType;
    private IExtendedDamageSource.DamageType damageType;
    private final int id;

    public DamageSourceExtended(String damageTypeIn, Entity damageSourceEntityIn, IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int id) {
        super(damageTypeIn, damageSourceEntityIn);
        LivingData entityCap = (LivingData)damageSourceEntityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        this.stunType = stunType;
        this.damageType = damageType;
        this.impact = entityCap.getImpact();
        this.armorIgnore = entityCap.getDefenceIgnore();
        this.id = id;
    }

    @Override
    public void setImpact(float amount) {
        this.impact = amount;
    }

    @Override
    public void setArmorIgnore(float amount) {
        this.armorIgnore = amount;
    }

    @Override
    public void setSureStrike(boolean value) {
        this.isSureStrike = value;
    }

    @Override
    public void setStunType(IExtendedDamageSource.StunType stunType) {
        this.stunType = stunType;
    }

    @Override
    public float getImpact() {
        return this.impact;
    }

    @Override
    public float getArmorIgnoreRatio() {
        return this.armorIgnore * 0.01f;
    }

    @Override
    public IExtendedDamageSource.StunType getStunType() {
        return this.stunType;
    }

    @Override
    public IExtendedDamageSource.DamageType getExtDamageType() {
        return this.damageType;
    }

    @Override
    public boolean isSureStrike() {
        return this.isSureStrike;
    }

    @Override
    public Entity getOwner() {
        return super.func_76346_g();
    }

    @Override
    public String getType() {
        return this.field_76373_n;
    }

    @Override
    public int getSkillId() {
        return this.id;
    }
}

