/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.utils.game;

import com.google.common.collect.Lists;
import java.util.List;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;

public class MainWeaponCombo {
    private Class<? extends Item> mainHand;
    private Class<? extends Item> offHand;
    private List<StaticAnimation> combo;

    public MainWeaponCombo(Class<? extends Item> mainHand, Class<? extends Item> offHand, StaticAnimation ... comboSeries) {
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.combo = Lists.newArrayList();
        for (StaticAnimation combo : comboSeries) {
            this.combo.add(combo);
        }
    }

    public List<StaticAnimation> getCombo(PlayerData<?> player) {
        if (this.isMatching(player)) {
            return this.combo;
        }
        return null;
    }

    public boolean isMatching(PlayerData<?> player) {
        PlayerEntity orgPlayer = (PlayerEntity)player.getOriginalEntity();
        Item offHand = orgPlayer.func_184592_cb().func_77973_b();
        Item mainHand = orgPlayer.func_184614_ca().func_77973_b();
        return MainWeaponCombo.compatible(mainHand.getClass(), this.mainHand) && MainWeaponCombo.compatible(offHand.getClass(), this.offHand);
    }

    private static boolean compatible(Class<? extends Item> a, Class<? extends Item> b) {
        if (a == null || b == null) {
            return true;
        }
        return a == b;
    }
}

