/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.utils.math;

import maninhouse.epicfight.utils.math.Mat4f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class MathUtils {
    public static Mat4f getModelMatrixIntegrated(float prevPosX, float posX, float prevPosY, float posY, float prevPosZ, float posZ, float prevPitch, float pitch, float prevYaw, float yaw, float partialTick) {
        Mat4f modelMatrix = new Mat4f().setIdentity();
        Vec3f entityPosition = new Vec3f(-(prevPosX + (posX - prevPosX) * partialTick), prevPosY + (posY - prevPosY) * partialTick, -(prevPosZ + (posZ - prevPosZ) * partialTick));
        Mat4f.translate(entityPosition, modelMatrix, modelMatrix);
        float pitchDegree = MathUtils.interpolateRotation(prevPitch, pitch, partialTick);
        float yawDegree = MathUtils.interpolateRotation(prevYaw, yaw, partialTick);
        Mat4f.rotate((float)(-Math.toRadians(yawDegree)), new Vec3f(0.0f, 1.0f, 0.0f), modelMatrix, modelMatrix);
        Mat4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), modelMatrix, modelMatrix);
        return modelMatrix;
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vec3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par1 + par3 * f;
    }

    public static float getInterpolatedRotation(float par1, float par2, float par3) {
        float f = 0.0f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return par3 * f;
    }
}

