/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.ESEventHandlerClient;
import com.Da_Technomancer.essentials.ESEventHandlerCommon;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.WitherCannon;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.AutoCrafterScreen;
import com.Da_Technomancer.essentials.gui.CircuitWrenchScreen;
import com.Da_Technomancer.essentials.gui.ConstantCircuitScreen;
import com.Da_Technomancer.essentials.gui.DelayCircuitScreen;
import com.Da_Technomancer.essentials.gui.FluidShifterScreen;
import com.Da_Technomancer.essentials.gui.ItemShifterScreen;
import com.Da_Technomancer.essentials.gui.PulseCircuitScreen;
import com.Da_Technomancer.essentials.gui.SlottedChestScreen;
import com.Da_Technomancer.essentials.gui.TimerCircuitScreen;
import com.Da_Technomancer.essentials.gui.container.AutoCrafterContainer;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.gui.container.ConstantCircuitContainer;
import com.Da_Technomancer.essentials.gui.container.DelayCircuitContainer;
import com.Da_Technomancer.essentials.gui.container.FluidShifterContainer;
import com.Da_Technomancer.essentials.gui.container.ItemShifterContainer;
import com.Da_Technomancer.essentials.gui.container.PulseCircuitContainer;
import com.Da_Technomancer.essentials.gui.container.SlottedChestContainer;
import com.Da_Technomancer.essentials.gui.container.TimerCircuitContainer;
import com.Da_Technomancer.essentials.items.ESItems;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.render.TESRRegistry;
import com.Da_Technomancer.essentials.tileentities.AutoCrafterTileEntity;
import com.Da_Technomancer.essentials.tileentities.BasicFluidSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.BasicItemSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.BrazierTileEntity;
import com.Da_Technomancer.essentials.tileentities.FluidShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.FluidSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.HopperFilterTileEntity;
import com.Da_Technomancer.essentials.tileentities.ItemShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.ItemSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.SlottedChestTileEntity;
import com.Da_Technomancer.essentials.tileentities.SortingHopperTileEntity;
import com.Da_Technomancer.essentials.tileentities.SpeedHopperTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.ConstantCircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.DelayCircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.PulseCircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.RedstoneReceiverTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.RedstoneTransmitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.TimerCircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.WireJunctionTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.WireTileEntity;
import com.mojang.datafixers.DSL;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="essentials")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Essentials {
    public static final String MODID = "essentials";
    public static final String MODNAME = "Essentials";
    public static final Logger logger = LogManager.getLogger((String)"Essentials");

    public Essentials() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonInit);
        bus.addListener(this::clientInit);
        ESConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ESConfig.load();
    }

    private void commonInit(FMLCommonSetupEvent e) {
        EssentialsPackets.preInit();
        RedstoneUtil.registerCap();
        MinecraftForge.EVENT_BUS.register((Object)new ESEventHandlerCommon());
    }

    private void clientInit(FMLClientSetupEvent e) {
        TESRRegistry.init();
        MinecraftForge.EVENT_BUS.register((Object)new ESEventHandlerClient());
        RenderTypeLookup.setRenderLayer((Block)ESBlocks.hopperFilter, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ESBlocks.candleLilyPad, (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        RenderingRegistry.registerEntityRenderingHandler(WitherCannon.ENT_TYPE, WitherSkullRenderer::new);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        ESBlocks.init();
        for (Block block : ESBlocks.toRegister) {
            registry.register((IForgeRegistryEntry)block);
        }
        ESBlocks.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        ESItems.init();
        for (Item item : ESItems.toRegister) {
            registry.register((IForgeRegistryEntry)item);
        }
        ESItems.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerEnts(RegistryEvent.Register<EntityType<?>> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(WitherCannon.CannonSkull::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(true).func_220321_a(0.3125f, 0.3125f).func_220320_c().setUpdateInterval(4).setTrackingRange(4).setCustomClientFactory((s, w) -> new WitherCannon.CannonSkull(WitherCannon.ENT_TYPE, (World)w)).func_206830_a("cannon_skull").setRegistryName(MODID, "cannon_skull")));
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        Essentials.registerTE(BrazierTileEntity::new, "brazier", reg, new Block[]{ESBlocks.brazier});
        Essentials.registerTE(SlottedChestTileEntity::new, "slotted_chest", reg, new Block[]{ESBlocks.slottedChest});
        Essentials.registerTE(SortingHopperTileEntity::new, "sorting_hopper", reg, new Block[]{ESBlocks.sortingHopper});
        Essentials.registerTE(SpeedHopperTileEntity::new, "speed_hopper", reg, new Block[]{ESBlocks.speedHopper});
        Essentials.registerTE(ItemShifterTileEntity::new, "item_shifter", reg, new Block[]{ESBlocks.itemShifter});
        Essentials.registerTE(FluidShifterTileEntity::new, "fluid_shifter", reg, new Block[]{ESBlocks.fluidShifter});
        Essentials.registerTE(HopperFilterTileEntity::new, "hopper_filter", reg, new Block[]{ESBlocks.hopperFilter});
        Essentials.registerTE(BasicItemSplitterTileEntity::new, "basic_item_splitter", reg, new Block[]{ESBlocks.basicItemSplitter});
        Essentials.registerTE(ItemSplitterTileEntity::new, "item_splitter", reg, new Block[]{ESBlocks.itemSplitter});
        Essentials.registerTE(BasicFluidSplitterTileEntity::new, "basic_fluid_splitter", reg, new Block[]{ESBlocks.basicFluidSplitter});
        Essentials.registerTE(FluidSplitterTileEntity::new, "fluid_splitter", reg, new Block[]{ESBlocks.fluidSplitter});
        Essentials.registerTE(CircuitTileEntity::new, "circuit", reg, new Block[]{ESBlocks.andCircuit, ESBlocks.orCircuit, ESBlocks.interfaceCircuit, ESBlocks.notCircuit, ESBlocks.xorCircuit, ESBlocks.maxCircuit, ESBlocks.minCircuit, ESBlocks.sumCircuit, ESBlocks.difCircuit, ESBlocks.prodCircuit, ESBlocks.quotCircuit, ESBlocks.powCircuit, ESBlocks.invCircuit, ESBlocks.cosCircuit, ESBlocks.sinCircuit, ESBlocks.tanCircuit, ESBlocks.asinCircuit, ESBlocks.acosCircuit, ESBlocks.atanCircuit, ESBlocks.readerCircuit, ESBlocks.moduloCircuit, ESBlocks.moreCircuit, ESBlocks.lessCircuit, ESBlocks.equalsCircuit, ESBlocks.absCircuit, ESBlocks.signCircuit});
        Essentials.registerTE(ConstantCircuitTileEntity::new, "cons_circuit", reg, new Block[]{ESBlocks.consCircuit});
        Essentials.registerTE(TimerCircuitTileEntity::new, "timer_circuit", reg, new Block[]{ESBlocks.timerCircuit});
        Essentials.registerTE(DelayCircuitTileEntity::new, "delay_circuit", reg, new Block[]{ESBlocks.delayCircuit});
        Essentials.registerTE(WireTileEntity::new, "wire", reg, new Block[]{ESBlocks.wireCircuit});
        Essentials.registerTE(WireJunctionTileEntity::new, "wire_junction", reg, new Block[]{ESBlocks.wireJunctionCircuit});
        Essentials.registerTE(AutoCrafterTileEntity::new, "auto_crafter", reg, new Block[]{ESBlocks.autoCrafter});
        Essentials.registerTE(RedstoneTransmitterTileEntity::new, "redstone_transmitter", reg, new Block[]{ESBlocks.redstoneTransmitter});
        Essentials.registerTE(RedstoneReceiverTileEntity::new, "redstone_receiver", reg, new Block[]{ESBlocks.redstoneReceiver});
        Essentials.registerTE(PulseCircuitTileEntity::new, "pulse_circuit", reg, new Block[]{ESBlocks.pulseCircuitRising, ESBlocks.pulseCircuitFalling, ESBlocks.pulseCircuitDual});
    }

    private static void registerTE(Supplier<? extends TileEntity> cons, String id, IForgeRegistry<TileEntityType<?>> reg, Block ... blocks) {
        TileEntityType teType = TileEntityType.Builder.func_223042_a(cons, (Block[])blocks).func_206865_a(DSL.emptyPartType());
        teType.setRegistryName(new ResourceLocation(MODID, id));
        reg.register((IForgeRegistryEntry)teType);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> e) {
        Essentials.registerCon(ItemShifterContainer::new, ItemShifterScreen::new, "item_shifter", e);
        Essentials.registerCon(FluidShifterContainer::new, FluidShifterScreen::new, "fluid_shifter", e);
        Essentials.registerCon(SlottedChestContainer::new, SlottedChestScreen::new, "slotted_chest", e);
        Essentials.registerCon(CircuitWrenchContainer::new, CircuitWrenchScreen::new, "circuit_wrench", e);
        Essentials.registerCon(ConstantCircuitContainer::new, ConstantCircuitScreen::new, "cons_circuit", e);
        Essentials.registerCon(TimerCircuitContainer::new, TimerCircuitScreen::new, "timer_circuit", e);
        Essentials.registerCon(AutoCrafterContainer::new, AutoCrafterScreen::new, "auto_crafter", e);
        Essentials.registerCon(DelayCircuitContainer::new, DelayCircuitScreen::new, "delay_circuit", e);
        Essentials.registerCon(PulseCircuitContainer::new, PulseCircuitScreen::new, "pulse_circuit", e);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> e) {
        Essentials.registerConType(ItemShifterContainer::new, "item_shifter", e);
        Essentials.registerConType(FluidShifterContainer::new, "fluid_shifter", e);
        Essentials.registerConType(SlottedChestContainer::new, "slotted_chest", e);
        Essentials.registerConType(CircuitWrenchContainer::new, "circuit_wrench", e);
        Essentials.registerConType(ConstantCircuitContainer::new, "cons_circuit", e);
        Essentials.registerConType(TimerCircuitContainer::new, "timer_circuit", e);
        Essentials.registerConType(AutoCrafterContainer::new, "auto_crafter", e);
        Essentials.registerConType(DelayCircuitContainer::new, "delay_circuit", e);
        Essentials.registerConType(PulseCircuitContainer::new, "pulse_circuit", e);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
    }

    private static <T extends Container> ContainerType<T> registerConType(IContainerFactory<T> cons, String id, RegistryEvent.Register<ContainerType<?>> reg) {
        ContainerType contType = new ContainerType(cons);
        contType.setRegistryName(new ResourceLocation(MODID, id));
        reg.getRegistry().register((IForgeRegistryEntry)contType);
        return contType;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends Container> void registerCon(IContainerFactory<T> cons, ScreenManager.IScreenFactory<T, ContainerScreen<T>> screenFactory, String id, RegistryEvent.Register<ContainerType<?>> reg) {
        ContainerType<T> contType = Essentials.registerConType(cons, id, reg);
        ScreenManager.func_216911_a(contType, screenFactory);
    }
}

