/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.WorldBuffer;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.MultiPistonExtend;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiPistonBase
extends Block {
    private static final int DIST_LIMIT = 15;
    private static final int PUSH_LIMIT = 64;
    private static final int DELAY = 2;
    private static final VoxelShape[] BB = new VoxelShape[]{MultiPistonBase.func_208617_a((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), MultiPistonBase.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0)};
    private final boolean sticky;
    protected static boolean changingWorld = false;

    protected MultiPistonBase(boolean sticky) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_76233_E).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        String name = "multi_piston" + (sticky ? "_sticky" : "");
        this.setRegistryName(name);
        this.sticky = sticky;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ESProperties.FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false)));
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ESProperties.FACING, ESProperties.EXTENDED, ESProperties.SHIFTING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ESProperties.FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.multi_piston.desc", new Object[]{15, 64}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.multi_piston.reds"));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)ESProperties.EXTENDED)).booleanValue()) {
            return BB[((Direction)state.func_177229_b((Property)ESProperties.FACING)).func_176745_a()];
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState otherState;
        if (!changingWorld && (newState.func_177230_c() != this || state.func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false)) != newState.func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false))) && ((Boolean)state.func_177229_b((Property)ESProperties.EXTENDED)).booleanValue() && (otherState = world.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)ESProperties.FACING)))).func_177230_c() == (this.sticky ? ESBlocks.multiPistonExtendSticky : ESBlocks.multiPistonExtend) && otherState.func_177229_b(ESProperties.AXIS) == ((Direction)state.func_177229_b((Property)ESProperties.FACING)).func_176740_k()) {
            world.func_175655_b(pos.func_177972_a((Direction)state.func_177229_b((Property)ESProperties.FACING)), false);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench(playerIn.func_184586_b(hand)) && !((Boolean)state.func_177229_b((Property)ESProperties.EXTENDED)).booleanValue() && !((Boolean)state.func_177229_b((Property)ESProperties.SHIFTING)).booleanValue()) {
            if (!worldIn.field_72995_K) {
                BlockState endState = (BlockState)state.func_235896_a_((Property)ESProperties.FACING);
                worldIn.func_175656_a(pos, endState);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public PushReaction func_149656_h(BlockState state) {
        return (Boolean)state.func_177229_b((Property)ESProperties.EXTENDED) != false || (Boolean)state.func_177229_b((Property)ESProperties.SHIFTING) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)ESProperties.SHIFTING)).booleanValue()) {
            double particleRad = 0.75;
            for (int i = 0; i < 4; ++i) {
                worldIn.func_195589_b((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() * particleRad, (double)pos.func_177956_o() + 0.5 + rand.nextGaussian() * particleRad, (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() * particleRad, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.func_220069_a(world.func_180495_p(pos), world, pos, this, pos, false);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        int currExtend;
        if (worldIn.field_72995_K || changingWorld || ((Boolean)state.func_177229_b((Property)ESProperties.SHIFTING)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        int redstone = this.getRedstoneInput(worldIn, pos, state, facing);
        if (redstone > (currExtend = this.getCurrentExtension(worldIn, pos, state, facing))) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.NORMAL);
            this.playSound(worldIn, pos, false, true);
        } else {
            this.func_225534_a_(state, (ServerWorld)worldIn, pos, worldIn.field_73012_v);
        }
    }

    private int getRedstoneInput(World world, BlockPos pos, BlockState state, Direction facing) {
        int target = 0;
        for (Direction dir : Direction.values()) {
            if (dir == facing) continue;
            target = Math.max(target, RedstoneUtil.getRedstoneOnSide(world, pos, dir));
        }
        if (facing == Direction.UP) {
            target = Math.min(target, world.func_217301_I() - pos.func_177956_o() - 1);
        } else if (facing == Direction.DOWN) {
            target = Math.min(target, pos.func_177956_o());
        }
        return target;
    }

    private void playSound(World world, BlockPos pos, boolean moving, boolean extension) {
        if (moving) {
            world.func_184133_a(null, pos, extension ? SoundEvents.field_187715_dR : SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187776_dp, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private int getCurrentExtension(World world, BlockPos pos, BlockState state, Direction facing) {
        int currentExtension = 0;
        if (((Boolean)state.func_177229_b((Property)ESProperties.EXTENDED)).booleanValue()) {
            Direction.AxisDirection dir;
            BlockPos checkPos = pos.func_177972_a(facing);
            BlockState curState = world.func_180495_p(checkPos);
            Block tarBlock = this.getExtensionBlock(this.sticky);
            while (curState.func_177230_c() == tarBlock && curState.func_177229_b(ESProperties.AXIS) == facing.func_176740_k() && (dir = MultiPistonExtend.getDirFromHead((Integer)curState.func_177229_b((Property)ESProperties.HEAD))) != facing.func_176734_d().func_176743_c() && currentExtension != 15) {
                ++currentExtension;
                checkPos = checkPos.func_177972_a(facing);
                curState = world.func_180495_p(checkPos);
                if (dir == null) continue;
                break;
            }
        }
        return currentExtension;
    }

    private Block getExtensionBlock(boolean sticky) {
        if (sticky) {
            return ESBlocks.multiPistonExtendSticky;
        }
        return ESBlocks.multiPistonExtend;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        Direction facing = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        int redstone = this.getRedstoneInput((World)world, pos, state, facing);
        int currExtend = this.getCurrentExtension((World)world, pos, state, facing);
        state = (BlockState)state.func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false));
        world.func_180501_a(pos, state, 2);
        if (currExtend == redstone) {
            return;
        }
        changingWorld = true;
        WorldBuffer wBuf = new WorldBuffer((World)world);
        if (currExtend < redstone) {
            boolean blocked = this.shiftExtension(wBuf, pos, facing, currExtend, true);
            if (!blocked && currExtend + 1 < redstone) {
                state = (BlockState)state.func_206870_a((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(true));
                world.func_180501_a(pos, state, 2);
                world.func_205220_G_().func_205362_a(pos, (Object)this, 2, TickPriority.NORMAL);
            }
            Set<BlockPos> toUpdate = wBuf.changedPositions();
            wBuf.applyChanges(67);
            for (BlockPos posToUpdate : toUpdate) {
                world.func_195593_d(posToUpdate, (Block)this);
            }
            if (!blocked) {
                this.playSound((World)world, pos, true, true);
                state = (BlockState)state.func_206870_a((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(redstone != 0));
                world.func_180501_a(pos, state, 2);
            }
        } else {
            for (int i = currExtend; i > redstone; --i) {
                this.shiftExtension(wBuf, pos, facing, i, false);
            }
            Set<BlockPos> toUpdate = wBuf.changedPositions();
            wBuf.applyChanges(67);
            for (BlockPos posToUpdate : toUpdate) {
                world.func_195593_d(posToUpdate, (Block)this);
            }
            this.playSound((World)world, pos, true, false);
            state = (BlockState)state.func_206870_a((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(redstone != 0));
            world.func_180501_a(pos, state, 2);
        }
        changingWorld = false;
    }

    private boolean shiftExtension(WorldBuffer world, BlockPos pos, Direction facing, int currentExtension, boolean out) {
        Direction moveDir = out ? facing : facing.func_176734_d();
        LinkedHashSet<BlockPos> movedBlocks = new LinkedHashSet<BlockPos>(65);
        BlockPos prevHeadPos = pos.func_177967_a(facing, currentExtension);
        Block extendBlock = this.getExtensionBlock(this.sticky);
        if (!out) {
            movedBlocks.add(prevHeadPos);
        }
        if ((out || this.sticky) && this.buildMoveset(pos, world, prevHeadPos.func_177972_a(facing), moveDir, movedBlocks, !out)) {
            if (!out) {
                movedBlocks.clear();
            } else {
                return true;
            }
        }
        if (!out) {
            movedBlocks.remove(prevHeadPos);
        }
        if (currentExtension != 0) {
            world.addChange(prevHeadPos, out ? (BlockState)extendBlock.func_176223_P().func_206870_a(ESProperties.AXIS, (Comparable)facing.func_176740_k()) : Blocks.field_150350_a.func_176223_P());
        }
        for (BlockPos changePos : movedBlocks) {
            BlockState prevState = world.func_180495_p(changePos);
            if (prevState.func_185905_o() == PushReaction.DESTROY) {
                world.getWorld().func_175655_b(changePos, true);
            } else {
                world.addChange(changePos.func_177972_a(moveDir), prevState);
            }
            world.addChange(changePos, Blocks.field_150350_a.func_176223_P());
            this.moveEnts(world.getWorld(), changePos, moveDir, prevState.isSlimeBlock());
        }
        this.moveEnts(world.getWorld(), prevHeadPos, moveDir, false);
        if (out) {
            world.addChange(pos.func_177967_a(facing, currentExtension + 1), (BlockState)((BlockState)extendBlock.func_176223_P().func_206870_a(ESProperties.AXIS, (Comparable)facing.func_176740_k())).func_206870_a((Property)ESProperties.HEAD, (Comparable)Integer.valueOf(facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : 2)));
        } else if (currentExtension != 1) {
            world.addChange(pos.func_177967_a(facing, currentExtension - 1), (BlockState)((BlockState)extendBlock.func_176223_P().func_206870_a(ESProperties.AXIS, (Comparable)facing.func_176740_k())).func_206870_a((Property)ESProperties.HEAD, (Comparable)Integer.valueOf(facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : 2)));
        }
        return false;
    }

    private void moveEnts(World world, BlockPos activePos, Direction moveDir, boolean sticky) {
        AxisAlignedBB BB = new AxisAlignedBB(activePos.func_177972_a(moveDir));
        ArrayList<Entity> movingEnts = new ArrayList<Entity>(4);
        MultiPistonBase.getEntitiesMultiChunk(BB, world, movingEnts);
        for (Entity ent : movingEnts) {
            if (ent.func_184192_z() == PushReaction.IGNORE) continue;
            ent.func_70634_a(ent.func_226277_ct_() + (double)moveDir.func_82601_c(), ent.func_226278_cu_() + (double)moveDir.func_96559_d(), ent.func_226281_cx_() + (double)moveDir.func_82599_e());
            if (!sticky) continue;
            ent.func_70024_g((double)moveDir.func_82601_c(), (double)moveDir.func_96559_d(), (double)moveDir.func_82599_e());
            ent.field_70133_I = true;
        }
        movingEnts.clear();
    }

    private boolean buildMoveset(BlockPos pistonPos, WorldBuffer world, BlockPos curPos, Direction moveDir, LinkedHashSet<BlockPos> movedBlocks, boolean dragging) {
        if (movedBlocks.contains(curPos)) {
            return false;
        }
        BlockState state = world.func_180495_p(curPos);
        PushReaction reaction = state.func_185905_o();
        if (state.func_177230_c().isAir(state, (IBlockReader)world.getWorld(), curPos)) {
            reaction = PushReaction.IGNORE;
        } else if (state.func_177230_c() == Blocks.field_150343_Z || state.func_177230_c().hasTileEntity(state) || pistonPos.equals((Object)curPos)) {
            reaction = PushReaction.BLOCK;
        } else if (state.func_185887_b((IBlockReader)world, curPos) < 0.0f) {
            reaction = PushReaction.BLOCK;
        } else if (state.func_177230_c() instanceof PistonBlock && state.func_235901_b_((Property)PistonBlock.field_176320_b)) {
            reaction = (Boolean)state.func_177229_b((Property)PistonBlock.field_176320_b) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
        }
        boolean blocked = false;
        switch (reaction) {
            case PUSH_ONLY: {
                if (dragging) break;
            }
            case NORMAL: {
                if (moveDir == Direction.UP && curPos.func_177956_o() == world.getWorld().func_217301_I() || moveDir == Direction.DOWN && curPos.func_177956_o() == 0) {
                    blocked = true;
                    break;
                }
                movedBlocks.add(curPos);
                blocked = movedBlocks.size() > 64 || this.buildMoveset(pistonPos, world, curPos.func_177972_a(moveDir), moveDir, movedBlocks, false);
                movedBlocks.remove(curPos);
                movedBlocks.add(curPos);
                if (state.isStickyBlock() && state.canStickTo(world.func_180495_p(curPos.func_177972_a(moveDir.func_176734_d())))) {
                    boolean bl = blocked = blocked || this.buildMoveset(pistonPos, world, curPos.func_177972_a(moveDir.func_176734_d()), moveDir, movedBlocks, true);
                }
                if (!state.isStickyBlock()) break;
                for (Direction side : Direction.values()) {
                    if (side.func_176740_k() == moveDir.func_176740_k() || !state.canStickTo(world.func_180495_p(curPos.func_177972_a(side)))) continue;
                    blocked = blocked || this.buildMoveset(pistonPos, world, curPos.func_177972_a(side), moveDir, movedBlocks, true);
                }
                break;
            }
            case DESTROY: {
                if (dragging) break;
                movedBlocks.add(curPos);
                break;
            }
            case BLOCK: {
                blocked = !dragging;
                break;
            }
        }
        return blocked || movedBlocks.size() > 64;
    }

    private static void getEntitiesMultiChunk(AxisAlignedBB checkBox, World worldIn, ArrayList<Entity> entList) {
        double maxEntityRad = worldIn.getMaxEntityRadius();
        int i = MathHelper.func_76128_c((double)((checkBox.field_72340_a - maxEntityRad) / 16.0)) - 1;
        int j = MathHelper.func_76128_c((double)((checkBox.field_72336_d + maxEntityRad) / 16.0)) + 1;
        int k = MathHelper.func_76128_c((double)((checkBox.field_72339_c - maxEntityRad) / 16.0)) - 1;
        int l = MathHelper.func_76128_c((double)((checkBox.field_72334_f + maxEntityRad) / 16.0)) + 1;
        int yMin = MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)((checkBox.field_72338_b - maxEntityRad) / 16.0)) - 1), (int)0, (int)15);
        int yMax = MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)((checkBox.field_72337_e + maxEntityRad) / 16.0)) + 1), (int)0, (int)15);
        for (int iLoop = i; iLoop <= j; ++iLoop) {
            for (int kLoop = k; kLoop <= l; ++kLoop) {
                if (!worldIn.func_217354_b(iLoop, kLoop)) continue;
                Chunk chunk = worldIn.func_175726_f(new BlockPos(iLoop * 16, 100, kLoop * 16));
                for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                    if (chunk.func_177429_s()[yLoop].isEmpty()) continue;
                    for (Entity entity : chunk.func_177429_s()[yLoop]) {
                        if (!entity.func_174813_aQ().func_72326_a(checkBox)) continue;
                        entList.add(entity);
                    }
                }
            }
        }
    }
}

