/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.items.ESItems;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.PulseCircuitTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PulseCircuit
extends AbstractCircuit {
    public final Edge edge;

    public PulseCircuit(Edge edge) {
        super("pulse_" + edge.name + "_circuit");
        this.edge = edge;
    }

    @Override
    public boolean useInput(CircuitTileEntity.Orient or) {
        return or == CircuitTileEntity.Orient.BACK;
    }

    @Override
    public float getOutput(float in0, float in1, float in2, CircuitTileEntity te) {
        if (te instanceof PulseCircuitTileEntity) {
            return ((PulseCircuitTileEntity)te).currentOutput(0);
        }
        return 0.0f;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench(playerIn.func_184586_b(hand))) {
            super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit);
        } else {
            TileEntity te;
            if (playerIn.func_184586_b(hand).func_77973_b() == ESItems.circuitWrench) {
                return ActionResultType.PASS;
            }
            if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof PulseCircuitTileEntity) {
                PulseCircuitTileEntity tte = (PulseCircuitTileEntity)te;
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)tte, buf -> CircuitContainer.encodeData(buf, te.func_174877_v(), tte.settingStrDuration));
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PulseCircuitTileEntity();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.pulse_circuit_" + this.edge.name));
    }

    public static enum Edge {
        RISING(true, false, "rising"),
        FALLING(false, true, "falling"),
        DUAL(true, true, "dual");

        public final String name;
        public final boolean start;
        public final boolean end;

        private Edge(boolean start, boolean end, String name) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.name;
        }
    }
}

