/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.packets.SendNBTToServer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CircuitScreen<T extends CircuitContainer>
extends ContainerScreen<T> {
    protected static final ResourceLocation SEARCH_BAR_TEXTURE = new ResourceLocation("essentials", "textures/gui/search_bar.png");
    protected static final ResourceLocation UI_TEXTURE = new ResourceLocation("essentials", "textures/gui/circuit_filler_back.png");
    protected TextFieldWidget[] inputBars;
    private static final Predicate<String> validator = s -> {
        String whitelist = "0123456789 xX*/+-^piPIeE().";
        for (int i = 0; i < s.length(); ++i) {
            if ("0123456789 xX*/+-^piPIeE().".contains(s.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    };

    public CircuitScreen(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        this.inputBars = new TextFieldWidget[((CircuitContainer)this.field_147002_h).inputBars()];
        this.field_146999_f = 176;
        this.field_147000_g = 90;
    }

    protected void createTextBar(int id, int x, int y, ITextComponent text) {
        this.inputBars[id] = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + x, this.field_147009_r + y, 140, 18, text);
        this.inputBars[id].func_146205_d(true);
        this.inputBars[id].func_146193_g(-1);
        this.inputBars[id].func_146204_h(-1);
        this.inputBars[id].func_146185_a(false);
        this.inputBars[id].func_146203_f(20);
        this.inputBars[id].func_146180_a(((CircuitContainer)this.field_147002_h).inputs[id]);
        this.inputBars[id].func_212954_a(this::entryChanged);
        this.inputBars[id].func_200675_a(validator);
        this.field_230705_e_.add(this.inputBars[id]);
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        int i;
        String[] text = new String[this.inputBars.length];
        for (i = 0; i < this.inputBars.length; ++i) {
            text[i] = this.inputBars[i].func_146179_b();
        }
        this.func_231158_b_(minecraft, width, height);
        for (i = 0; i < this.inputBars.length; ++i) {
            this.inputBars[i].func_146180_a(text[i]);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        for (TextFieldWidget bar : this.inputBars) {
            if (!bar.func_231046_a_(keyCode, scanCode, modifiers) && !bar.func_212955_f()) continue;
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        RenderSystem.disableBlend();
        for (TextFieldWidget bar : this.inputBars) {
            bar.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int x, int y) {
        this.field_230706_i_.func_110434_K().func_110577_a(UI_TEXTURE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, 90);
        this.field_230706_i_.func_110434_K().func_110577_a(SEARCH_BAR_TEXTURE);
        for (TextFieldWidget bar : this.inputBars) {
            CircuitScreen.func_238463_a_((MatrixStack)matrix, (int)(bar.field_230690_l_ - 2), (int)(bar.field_230691_m_ - 8), (float)0.0f, (float)0.0f, (int)144, (int)18, (int)144, (int)18);
        }
        for (TextFieldWidget inputBar : this.inputBars) {
            this.field_230712_o_.func_243248_b(matrix, inputBar.func_230458_i_(), (float)(inputBar.field_230690_l_ - 2), (float)(inputBar.field_230691_m_ - 16), 0x404040);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int x, int y) {
    }

    protected void entryChanged(String newFilter) {
        CompoundNBT nbt = new CompoundNBT();
        for (int i = 0; i < this.inputBars.length; ++i) {
            float output = RedstoneUtil.interpretFormulaString(this.inputBars[i].func_146179_b());
            ((CircuitContainer)this.field_147002_h).inputs[i] = this.inputBars[i].func_146179_b();
            nbt.func_74776_a("value_" + i, output);
            nbt.func_74778_a("text_" + i, ((CircuitContainer)this.field_147002_h).inputs[i]);
        }
        if (((CircuitContainer)this.field_147002_h).pos != null) {
            EssentialsPackets.channel.sendToServer((Object)new SendNBTToServer(nbt, ((CircuitContainer)this.field_147002_h).pos));
        }
    }
}

