/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FluidSlotManager {
    private static BiMap<ResourceLocation, Short> fluidIDs = null;
    private final int capacity;
    private int fluidId;
    private int fluidQty;
    private final ArrayList<WeakReference<Slot>> fluidItemInSlots = new ArrayList(1);
    private int windowXStart;
    private int windowYStart;
    private int xPos;
    private int yPos;
    private IntReferenceHolder idRef;
    private IntReferenceHolder qtyRef;
    private static final int MAX_HEIGHT = 48;
    private static final ResourceLocation OVERLAY = new ResourceLocation("essentials", "textures/gui/rectangle_fluid_overlay.png");

    private static BiMap<ResourceLocation, Short> getFluidMap() {
        if (fluidIDs == null) {
            fluidIDs = HashBiMap.create((int)ForgeRegistries.FLUIDS.getKeys().size());
            short[] value = new short[]{0};
            ForgeRegistries.FLUIDS.getKeys().stream().sorted(ResourceLocation::compareTo).forEach(key -> {
                short s = value[0];
                value[0] = (short)(s + 1);
                Short cfr_ignored_0 = (Short)fluidIDs.put(key, (Object)s);
            });
        }
        return fluidIDs;
    }

    public FluidSlotManager(FluidStack init, int capacity) {
        this.capacity = capacity;
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)init.getFluid().getRegistryName(), (Object)-1)).shortValue();
        this.fluidQty = init.getAmount() - Short.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initScreen(int windowXStart, int windowYStart, int xPos, int yPos, IntReferenceHolder idRef, IntReferenceHolder qtyRef) {
        this.windowXStart = windowXStart;
        this.windowYStart = windowYStart;
        this.xPos = xPos;
        this.yPos = yPos;
        this.idRef = idRef;
        this.qtyRef = qtyRef;
        this.idRef.func_221494_a(this.fluidId);
        this.qtyRef.func_221494_a(this.fluidQty);
    }

    public void linkSlot(Slot fluidItemInputSlot) {
        this.fluidItemInSlots.add(new WeakReference<Slot>(fluidItemInputSlot));
    }

    public int getFluidId() {
        return this.fluidId;
    }

    public int getFluidQty() {
        return this.fluidQty;
    }

    public void updateState(FluidStack newFluid) {
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)newFluid.getFluid().getRegistryName(), (Object)-1)).shortValue();
        this.fluidQty = newFluid.getAmount() - Short.MAX_VALUE;
        for (int index = 0; index < this.fluidItemInSlots.size(); ++index) {
            Slot contents = (Slot)this.fluidItemInSlots.get(index).get();
            if (contents == null) {
                this.fluidItemInSlots.remove(index);
                --index;
                continue;
            }
            contents.func_75218_e();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getStack() {
        short fluidId = (short)this.idRef.func_221495_b();
        if (fluidId < 0) {
            return FluidStack.EMPTY;
        }
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue((ResourceLocation)FluidSlotManager.getFluidMap().inverse().getOrDefault((Object)fluidId, (Object)Fluids.field_204546_a.getRegistryName()));
        if (f == null) {
            f = Fluids.field_204546_a;
        }
        return new FluidStack(f, this.qtyRef.func_221495_b() + Short.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrix, float partialTicks, int mouseX, int mouseY, FontRenderer fontRenderer, List<ITextComponent> tooltip) {
        FluidStack clientState = this.getStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Screen.func_238467_a_((MatrixStack)matrix, (int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - 48), (int)(this.xPos + this.windowXStart + 16), (int)(this.yPos + this.windowYStart), (int)-6974059);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidAttributes attr = clientState.getFluid().getAttributes();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(attr.getStillTexture());
        int col = attr.getColor(clientState);
        int height = (int)(48.0f * (float)clientState.getAmount() / (float)this.capacity);
        RenderSystem.color3f((float)((float)(col >>> 16 & 0xFF) / 255.0f), (float)((float)(col >>> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f));
        Screen.func_238470_a_((MatrixStack)matrix, (int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - height), (int)0, (int)16, (int)height, (TextureAtlasSprite)sprite);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(OVERLAY);
        Screen.func_238463_a_((MatrixStack)matrix, (int)(this.windowXStart + this.xPos), (int)(this.windowYStart + this.yPos - 48), (float)0.0f, (float)0.0f, (int)16, (int)48, (int)16, (int)48);
        if (mouseX >= this.xPos + this.windowXStart && mouseX <= this.xPos + this.windowXStart + 16 && mouseY >= this.yPos + this.windowYStart - 48 && mouseY <= this.yPos + this.windowYStart) {
            if (clientState.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fluid_contents.empty"));
            } else {
                tooltip.add(clientState.getDisplayName());
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fluid_contents", new Object[]{clientState.getAmount(), this.capacity}));
        }
    }

    public static Pair<Slot, Slot> createFluidSlots(IInventory inv, int startIndex, int inXPos, int inYPos, int outXPos, int outYPos, @Nullable IFluidSlotTE te, int[] fluidIndex) {
        InSlot in = new InSlot(inv, startIndex + 1, inXPos, inYPos, startIndex, te, fluidIndex);
        OutSlot out = new OutSlot(inv, startIndex, outXPos, outYPos, in);
        return Pair.of((Object)((Object)out), (Object)((Object)in));
    }

    public static class FakeInventory
    implements IInventory {
        private final Container container;
        private final ItemStack[] stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};

        public FakeInventory(Container cont) {
            this.container = cont;
        }

        public int func_70302_i_() {
            return 2;
        }

        public boolean func_191420_l() {
            return this.stacks[0].func_190926_b() && this.stacks[1].func_190926_b();
        }

        public ItemStack func_70301_a(int index) {
            return this.stacks[index];
        }

        public ItemStack func_70298_a(int index, int count) {
            this.func_70296_d();
            return this.stacks[index].func_77979_a(count);
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = this.stacks[index];
            this.stacks[index] = ItemStack.field_190927_a;
            this.func_70296_d();
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks[index] = stack;
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            this.container.func_75142_b();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0 && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public void func_174888_l() {
            this.stacks[0] = ItemStack.field_190927_a;
            this.stacks[1] = ItemStack.field_190927_a;
            this.func_70296_d();
        }
    }

    private static class InSlot
    extends Slot {
        private final int outSlotIndex;
        @Nullable
        private final IFluidSlotTE te;
        private final int[] fluidIndices;
        private boolean internalChange = false;

        private InSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, int outSlotIndex, @Nullable IFluidSlotTE te, int[] fluidIndices) {
            super(inventoryIn, index, xPosition, yPosition);
            this.outSlotIndex = outSlotIndex;
            this.te = te;
            this.fluidIndices = fluidIndices;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public void func_75218_e() {
            super.func_75218_e();
            ItemStack inSlot = this.func_75211_c();
            if (!this.internalChange && this.te != null && this.func_75214_a(inSlot)) {
                this.internalChange = true;
                ItemStack outSlot = this.field_75224_c.func_70301_a(this.outSlotIndex);
                ItemStack inSlotCopy = inSlot.func_77946_l();
                inSlotCopy.func_190920_e(1);
                LazyOptional opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                IFluidHandler teHandler = this.te.getFluidHandler();
                if (opt.isPresent()) {
                    IFluidHandlerItem itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                    if (outSlot.func_190926_b()) {
                        for (int fluidIndex : this.fluidIndices) {
                            FluidStack filled;
                            int filledQty;
                            int drainQty = teHandler.getTankCapacity(fluidIndex) - teHandler.getFluidInTank(fluidIndex).getAmount();
                            FluidStack drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.SIMULATE);
                            if (teHandler.isFluidValid(fluidIndex, drained)) {
                                drainQty = teHandler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                                drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.EXECUTE);
                                if ((drainQty = drained.getAmount()) > 0) {
                                    teHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                                    this.field_75224_c.func_70299_a(this.outSlotIndex, itemHandler.getContainer());
                                    inSlot.func_190918_g(1);
                                    this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                                    this.field_75224_c.func_70296_d();
                                    this.internalChange = false;
                                    return;
                                }
                            }
                            if ((filledQty = itemHandler.fill(filled = teHandler.drain(0x3FFFFFFF, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                            filled.setAmount(filledQty);
                            teHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            this.field_75224_c.func_70299_a(this.outSlotIndex, itemHandler.getContainer());
                            inSlot.func_190918_g(1);
                            this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                            this.internalChange = false;
                            return;
                        }
                    } else {
                        for (int fluidIndex : this.fluidIndices) {
                            int drainQty = teHandler.getTankCapacity(fluidIndex) - teHandler.getFluidInTank(fluidIndex).getAmount();
                            FluidStack drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.SIMULATE);
                            if (teHandler.isFluidValid(fluidIndex, drained)) {
                                drainQty = teHandler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                                drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.EXECUTE);
                                drainQty = drained.getAmount();
                                ItemStack containerResult = itemHandler.getContainer();
                                if (drainQty > 0 && (containerResult.func_190926_b() || BlockUtil.sameItem(containerResult, outSlot) && outSlot.func_190916_E() + containerResult.func_190916_E() <= containerResult.func_77976_d())) {
                                    teHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                                    outSlot.func_190917_f(containerResult.func_190916_E());
                                    this.field_75224_c.func_70299_a(this.outSlotIndex, outSlot);
                                    inSlot.func_190918_g(1);
                                    this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                                    this.field_75224_c.func_70296_d();
                                    this.internalChange = false;
                                    return;
                                }
                                inSlotCopy = inSlot.func_77946_l();
                                inSlotCopy.func_190920_e(1);
                                opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                                itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                                this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                            }
                            FluidStack filled = teHandler.drain(0x3FFFFFFF, IFluidHandler.FluidAction.SIMULATE);
                            int filledQty = itemHandler.fill(filled, IFluidHandler.FluidAction.EXECUTE);
                            ItemStack containerResult = itemHandler.getContainer();
                            if (filledQty > 0 && (containerResult.func_190926_b() || BlockUtil.sameItem(containerResult, outSlot) && outSlot.func_190916_E() + containerResult.func_190916_E() <= containerResult.func_77976_d())) {
                                filled.setAmount(filledQty);
                                teHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                                outSlot.func_190917_f(containerResult.func_190916_E());
                                this.field_75224_c.func_70299_a(this.outSlotIndex, outSlot);
                                inSlot.func_190918_g(1);
                                this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                                this.internalChange = false;
                                return;
                            }
                            inSlotCopy = inSlot.func_77946_l();
                            inSlotCopy.func_190920_e(1);
                            opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                            itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                            this.field_75224_c.func_70299_a(this.getSlotIndex(), inSlot);
                        }
                    }
                }
                this.internalChange = false;
            }
        }
    }

    private static class OutSlot
    extends Slot {
        private final InSlot inSlot;

        private OutSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, InSlot inSlot) {
            super(inventoryIn, index, xPosition, yPosition);
            this.inSlot = inSlot;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
            ItemStack s = super.func_190901_a(player, stack);
            this.inSlot.func_75218_e();
            return s;
        }
    }
}

