/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractShifterTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private Direction facing = null;
    protected BlockPos endPos = null;

    protected <T extends AbstractShifterTileEntity> AbstractShifterTileEntity(TileEntityType<T> type) {
        super(type);
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.func_195044_w();
            if (!state.func_235901_b_((Property)ESProperties.FACING)) {
                return Direction.DOWN;
            }
            this.facing = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        }
        return this.facing;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.facing = null;
        this.refreshCache();
    }

    public void refreshCache() {
        BlockState target;
        int extension;
        Direction dir = this.getFacing();
        int maxChutes = (Integer)ESConfig.itemChuteRange.get();
        for (extension = 1; extension <= maxChutes && (target = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(dir, extension))).func_177230_c() == ESBlocks.itemChute && target.func_177229_b(ESProperties.AXIS) == dir.func_176740_k(); ++extension) {
        }
        this.endPos = this.field_174879_c.func_177967_a(dir, extension);
    }

    public static ItemStack ejectItem(World world, BlockPos outputPos, Direction fromSide, ItemStack stack, @Nullable LazyOptional<IItemHandler> outputHandlerCache) {
        BlockState outputState;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IItemHandler handler = null;
        if (outputHandlerCache == null) {
            LazyOptional outputCap;
            TileEntity outputTE = world.func_175625_s(outputPos);
            if (outputTE != null && (outputCap = outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromSide.func_176734_d())).isPresent()) {
                handler = (IItemHandler)outputCap.orElseThrow(NullPointerException::new);
            }
        } else if (outputHandlerCache.isPresent()) {
            handler = (IItemHandler)outputHandlerCache.orElseThrow(NullPointerException::new);
        }
        if (handler == null && (outputState = world.func_180495_p(outputPos)).func_177230_c() instanceof ISidedInventoryProvider) {
            ISidedInventory inv = ((ISidedInventoryProvider)outputState.func_177230_c()).func_219966_a(outputState, (IWorld)world, outputPos);
            handler = new InvWrapper((IInventory)inv);
        }
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack outStack = handler.insertItem(i, stack, false);
                if (outStack.func_190916_E() == stack.func_190916_E()) continue;
                return outStack;
            }
            return stack;
        }
        ItemEntity ent = new ItemEntity(world, (double)outputPos.func_177958_n() + 0.5, (double)outputPos.func_177956_o() + 0.5, (double)outputPos.func_177952_p() + 0.5, stack);
        ent.func_213317_d(Vector3d.field_186680_a);
        world.func_217376_c((Entity)ent);
        return ItemStack.field_190927_a;
    }

    public static FluidStack ejectFluid(World world, BlockPos pos, Direction fromSide, FluidStack stack) {
        LazyOptional outHandlerCon;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        TileEntity outputTE = world.func_175625_s(pos);
        if (outputTE != null && (outHandlerCon = outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fromSide.func_176734_d())).isPresent()) {
            IFluidHandler outHandler = (IFluidHandler)outHandlerCon.orElseThrow(NullPointerException::new);
            int filled = outHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            FluidStack out = stack.copy();
            out.shrink(filled);
            return out;
        }
        return stack;
    }
}

