/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.DelayCircuitContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.TickPriority;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

@ObjectHolder(value="essentials")
public class DelayCircuitTileEntity
extends CircuitTileEntity
implements INamedContainerProvider,
INBTReceiver,
ITickableTileEntity {
    @ObjectHolder(value="delay_circuit")
    private static TileEntityType<DelayCircuitTileEntity> TYPE = null;
    private static final int MIN_DELAY = 1;
    public int settingDelay = 2;
    public String settingStrDelay = "2";
    private long ticksExisted = 0L;
    private float currentOutput = 0.0f;
    private final ArrayList<Pair<Float, Long>> queuedOutputs = new ArrayList();

    public DelayCircuitTileEntity() {
        super(TYPE);
    }

    public float currentOutput() {
        return this.currentOutput;
    }

    @Override
    protected AbstractCircuit getOwner() {
        return ESBlocks.delayCircuit;
    }

    @Override
    public void handleInputChange(TickPriority priority) {
        float[] inputs = this.getInputs(this.getOwner());
        float input = inputs[1];
        if (this.queuedOutputs.isEmpty() ? RedstoneUtil.didChange(input, this.currentOutput) : RedstoneUtil.didChange(input, ((Float)this.queuedOutputs.get(this.queuedOutputs.size() - 1).getLeft()).floatValue())) {
            int delay = 2 * this.settingDelay;
            this.queuedOutputs.add((Pair<Float, Long>)Pair.of((Object)Float.valueOf(input), (Object)((long)delay + this.ticksExisted - this.ticksExisted % 2L)));
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K && !this.queuedOutputs.isEmpty()) {
            long removeTime;
            boolean didChange = false;
            do {
                Pair<Float, Long> nextInQueue;
                if ((removeTime = ((Long)(nextInQueue = this.queuedOutputs.get(0)).getRight()).longValue()) > this.ticksExisted) continue;
                this.queuedOutputs.remove(0);
                this.currentOutput = ((Float)nextInQueue.getLeft()).floatValue();
                didChange = true;
            } while (removeTime <= this.ticksExisted && !this.queuedOutputs.isEmpty());
            if (didChange) {
                this.recalculateOutput();
                this.func_70296_d();
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("setting_d", this.settingDelay);
        nbt.func_74778_a("setting_s_d", this.settingStrDelay);
        nbt.func_74772_a("existed", this.ticksExisted);
        nbt.func_74776_a("curr_output", this.currentOutput);
        for (int i = 0; i < this.queuedOutputs.size(); ++i) {
            Pair<Float, Long> outputPair = this.queuedOutputs.get(i);
            nbt.func_74776_a(i + "_queue_out", ((Float)outputPair.getLeft()).floatValue());
            nbt.func_74772_a(i + "_queue_time", ((Long)outputPair.getRight()).longValue());
        }
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.settingDelay = nbt.func_74762_e("setting_d");
        this.settingStrDelay = nbt.func_74779_i("setting_s_d");
        this.ticksExisted = nbt.func_74763_f("existed");
        this.currentOutput = nbt.func_74760_g("curr_output");
        int i = 0;
        this.queuedOutputs.clear();
        while (nbt.func_74764_b(i + "_queue_out")) {
            this.queuedOutputs.add((Pair<Float, Long>)Pair.of((Object)Float.valueOf(nbt.func_74760_g(i + "queue_out")), (Object)nbt.func_74763_f(i + "queue_time")));
            ++i;
            if (this.queuedOutputs.size() != Short.MAX_VALUE) continue;
            break;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.delay_circuit");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new DelayCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.field_174879_c, this.settingStrDelay));
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        this.settingDelay = Math.max(1, Math.round(nbt.func_74760_g("value_0")));
        this.settingStrDelay = nbt.func_74779_i("text_0");
        if (!this.queuedOutputs.isEmpty()) {
            this.currentOutput = ((Float)this.queuedOutputs.get(this.queuedOutputs.size() - 1).getLeft()).floatValue();
            this.queuedOutputs.clear();
        }
        this.func_70296_d();
        this.recalculateOutput();
    }
}

