/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.redstone.PulseCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.PulseCircuitContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.TickPriority;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class PulseCircuitTileEntity
extends CircuitTileEntity
implements INamedContainerProvider,
INBTReceiver,
ITickableTileEntity {
    @ObjectHolder(value="pulse_circuit")
    private static TileEntityType<PulseCircuitTileEntity> TYPE = null;
    private static final int MIN_DURATION = 1;
    public int settingDuration = 1;
    public String settingStrDuration = "1";
    private long ticksExisted = 0L;
    private long pulseStTime = -10L;
    private boolean hadInput = false;

    public PulseCircuitTileEntity() {
        super(TYPE);
    }

    public float currentOutput(int offset) {
        long currTime = this.ticksExisted + (long)offset;
        return this.pulseStTime <= currTime && (long)this.settingDuration > (currTime - this.pulseStTime - 1L) / 2L ? 1.0f : 0.0f;
    }

    private PulseCircuit.Edge getEdge() {
        Block b = this.func_195044_w().func_177230_c();
        if (b instanceof PulseCircuit) {
            return ((PulseCircuit)b).edge;
        }
        this.func_145843_s();
        return PulseCircuit.Edge.RISING;
    }

    @Override
    public void handleInputChange(TickPriority priority) {
        boolean activeInput;
        float[] inputs = this.getInputs(this.getOwner());
        float input = inputs[1];
        boolean bl = activeInput = input > 0.0f;
        if (activeInput != this.hadInput) {
            this.hadInput = activeInput;
            boolean addPulse = activeInput ? this.getEdge().start : this.getEdge().end;
            if (addPulse) {
                this.pulseStTime = this.ticksExisted;
            }
            this.func_70296_d();
        }
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K && RedstoneUtil.didChange(this.currentOutput(-2), this.currentOutput(-1))) {
            this.recalculateOutput();
            this.func_70296_d();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("setting_d", this.settingDuration);
        nbt.func_74778_a("setting_s_d", this.settingStrDuration);
        nbt.func_74772_a("existed", this.ticksExisted);
        nbt.func_74772_a("st_time", this.pulseStTime);
        nbt.func_74757_a("input", this.hadInput);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.settingDuration = nbt.func_74762_e("setting_d");
        this.settingStrDuration = nbt.func_74779_i("setting_s_d");
        this.ticksExisted = nbt.func_74763_f("existed");
        this.pulseStTime = nbt.func_74763_f("st_time");
        this.hadInput = nbt.func_74767_n("input");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.pulse_circuit_" + this.getEdge().name);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new PulseCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.field_174879_c, this.settingStrDuration));
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        this.settingDuration = Math.max(Math.round(nbt.func_74760_g("value_0")), 1);
        this.settingStrDuration = nbt.func_74779_i("text_0");
        this.func_70296_d();
        this.recalculateOutput();
    }
}

