/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.TimerCircuitContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class TimerCircuitTileEntity
extends CircuitTileEntity
implements INamedContainerProvider,
INBTReceiver,
ITickableTileEntity {
    @ObjectHolder(value="timer_circuit")
    private static TileEntityType<TimerCircuitTileEntity> TYPE = null;
    private static final int MIN_PERIOD = 1;
    private static final int MIN_DURATION = 0;
    public int settingPeriod = 4;
    public String settingStrPeriod = "4";
    public int settingDuration = 2;
    public String settingStrDuration = "2";
    private long ticksExisted = 0L;

    public TimerCircuitTileEntity() {
        super(TYPE);
    }

    @Override
    protected AbstractCircuit getOwner() {
        return ESBlocks.timerCircuit;
    }

    public int timerOutput() {
        if (this.ticksExisted / 2L % (long)this.settingPeriod < (long)this.settingDuration) {
            return 1;
        }
        return 0;
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        int clockTime = (int)(this.ticksExisted / 2L) % this.settingPeriod;
        if (!(this.field_145850_b.field_72995_K || this.ticksExisted % 2L != 0L || clockTime != 0 && clockTime != this.settingDuration)) {
            this.recalculateOutput();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("setting_p", this.settingPeriod);
        nbt.func_74778_a("setting_s_p", this.settingStrPeriod);
        nbt.func_74768_a("setting_d", this.settingDuration);
        nbt.func_74778_a("setting_s_d", this.settingStrDuration);
        nbt.func_74772_a("existed", this.ticksExisted);
        return nbt;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("setting_p", this.settingPeriod);
        nbt.func_74778_a("setting_s_p", this.settingStrPeriod);
        nbt.func_74768_a("setting_d", this.settingDuration);
        nbt.func_74778_a("setting_s_d", this.settingStrDuration);
        nbt.func_74772_a("existed", this.ticksExisted);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.settingPeriod = nbt.func_74762_e("setting_p");
        this.settingStrPeriod = nbt.func_74779_i("setting_s_p");
        this.settingDuration = nbt.func_74762_e("setting_d");
        this.settingStrDuration = nbt.func_74779_i("setting_s_d");
        this.ticksExisted = nbt.func_74763_f("existed");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.timer_circuit");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new TimerCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.field_174879_c, this.settingStrPeriod, this.settingStrDuration));
    }

    @Override
    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity sender) {
        this.settingPeriod = Math.max(1, Math.round(nbt.func_74760_g("value_0")));
        this.settingStrPeriod = nbt.func_74779_i("text_0");
        this.settingDuration = Math.max(0, Math.round(nbt.func_74760_g("value_1")));
        this.settingStrDuration = nbt.func_74779_i("text_1");
        this.func_70296_d();
        this.recalculateOutput();
    }
}

