/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

public class WireTileEntity
extends TileEntity {
    @ObjectHolder(value="essentials:wire")
    private static TileEntityType<WireTileEntity> TYPE = null;
    public long lastUpdateTime;
    protected LazyOptional<RedsHandler> redsOptional = LazyOptional.of(this::createRedsHandler);

    protected WireTileEntity(TileEntityType<? extends WireTileEntity> type) {
        super(type);
    }

    public WireTileEntity() {
        this(TYPE);
    }

    protected RedsHandler createRedsHandler() {
        return new RedsHandler();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.redsOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY && (side == null || side.func_176740_k() != Direction.Axis.Y)) {
            return this.redsOptional;
        }
        return super.getCapability(cap, side);
    }

    protected class RedsHandler
    implements IRedstoneHandler {
        protected RedsHandler() {
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireTileEntity.this.field_174879_c);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                TileEntity neighbor;
                if (dir == fromSide || (neighbor = WireTileEntity.this.field_145850_b.func_175625_s(WireTileEntity.this.field_174879_c.func_177972_a(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeDependents(src, dist, dir.func_176734_d(), nominalSide, visited);
                    continue;
                }
                handler.findDependents(src, dist, dir.func_176734_d(), nominalSide);
            }
        }

        protected void routeDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide, HashSet<BlockPos> visited) {
            if (!visited.add(WireTileEntity.this.field_174879_c) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                TileEntity neighbor;
                if (dir == fromSide || (neighbor = WireTileEntity.this.field_145850_b.func_175625_s(WireTileEntity.this.field_174879_c.func_177972_a(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeDependents(src, dist, dir.func_176734_d(), nominalSide, visited);
                    continue;
                }
                handler.findDependents(src, dist, dir.func_176734_d(), nominalSide);
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
            if (dist + 1 >= RedstoneUtil.getMaxRange()) {
                return;
            }
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(WireTileEntity.this.field_174879_c);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                TileEntity neighbor;
                if (dir == toSide || (neighbor = WireTileEntity.this.field_145850_b.func_175625_s(WireTileEntity.this.field_174879_c.func_177972_a(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeSrc(dependency, dist, dir.func_176734_d(), nominalSide, visited);
                    continue;
                }
                handler.requestSrc(dependency, dist, dir.func_176734_d(), nominalSide);
            }
        }

        protected void routeSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide, HashSet<BlockPos> visited) {
            if (!visited.add(WireTileEntity.this.field_174879_c) || ++dist >= RedstoneUtil.getMaxRange()) {
                return;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                IRedstoneHandler handler;
                TileEntity neighbor;
                if (dir == toSide || (neighbor = WireTileEntity.this.field_145850_b.func_175625_s(WireTileEntity.this.field_174879_c.func_177972_a(dir))) == null || (handler = (IRedstoneHandler)RedstoneUtil.get(neighbor.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, dir.func_176734_d()))) == null) continue;
                if (handler instanceof RedsHandler) {
                    ((RedsHandler)handler).routeSrc(dependency, dist, dir.func_176734_d(), nominalSide, visited);
                    continue;
                }
                handler.requestSrc(dependency, dist, dir.func_176734_d(), nominalSide);
            }
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
        }
    }
}

