/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.Essentials;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.LogMarkers;

public final class ReflectionUtil {
    @Nullable
    public static Method reflectMethod(IReflectionKey key) {
        return ReflectionUtil.reflectMethod(key, method -> true);
    }

    @Nullable
    public static Method reflectMethod(IReflectionKey key, Predicate<Method> additionalFilter) {
        try {
            String mcp = key.getMcpName();
            String obf = key.getObfName();
            assert (key.getSourceClass() != null);
            for (Method m : key.getSourceClass().getDeclaredMethods()) {
                if (!mcp.equals(m.getName()) && !obf.equals(m.getName()) || !additionalFilter.test(m)) continue;
                m.setAccessible(true);
                return m;
            }
        }
        catch (Exception e) {
            Essentials.logger.error(LogMarkers.LOADING, "Failed to reflect method: " + key.getMcpName() + "; Report to mod author; Disabling relevant feature(s): " + key.getPurpose(), (Throwable)e);
        }
        return null;
    }

    @Nullable
    public static Field reflectField(IReflectionKey key) {
        try {
            String mcp = key.getMcpName();
            String obf = key.getObfName();
            assert (key.getSourceClass() != null);
            for (Field f : key.getSourceClass().getDeclaredFields()) {
                if (!mcp.equals(f.getName()) && !obf.equals(f.getName())) continue;
                f.setAccessible(true);
                return f;
            }
        }
        catch (Exception e) {
            Essentials.logger.error(LogMarkers.LOADING, "Failed to reflect field: " + key.getMcpName() + "; Report to mod author; Disabling relevant feature(s): " + key.getPurpose(), (Throwable)e);
        }
        return null;
    }

    public static interface IReflectionKey {
        @Nullable
        public Class<?> getSourceClass();

        public String getObfName();

        public String getMcpName();

        public String getPurpose();
    }

    public static final class EsReflection
    extends Enum<EsReflection>
    implements IReflectionKey {
        private final Class<?> clazz;
        public final String obf;
        public final String mcp;
        private final String purpose;
        private static final /* synthetic */ EsReflection[] $VALUES;

        public static EsReflection[] values() {
            return (EsReflection[])$VALUES.clone();
        }

        public static EsReflection valueOf(String name) {
            return Enum.valueOf(EsReflection.class, name);
        }

        private EsReflection(@Nullable Class<?> clazz, String obf, String mcp, String purpose) {
            this.clazz = clazz;
            this.obf = obf;
            this.mcp = mcp == null ? "NOT-MAPPED" : mcp;
            this.purpose = purpose;
        }

        @Override
        @Nullable
        public Class<?> getSourceClass() {
            return this.clazz;
        }

        @Override
        public String getObfName() {
            return this.obf;
        }

        @Override
        public String getMcpName() {
            return this.mcp;
        }

        @Override
        public String getPurpose() {
            return this.purpose;
        }

        private static /* synthetic */ EsReflection[] $values() {
            return new EsReflection[0];
        }

        static {
            $VALUES = EsReflection.$values();
        }
    }
}

