/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.WorldBuffer;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.MultiPistonExtend;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiPistonBase
extends Block {
    private static final int DIST_LIMIT = 15;
    private static final int PUSH_LIMIT = 64;
    private static final int DELAY = 2;
    private static final VoxelShape[] BB = new VoxelShape[]{MultiPistonBase.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), MultiPistonBase.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), MultiPistonBase.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0)};
    private final boolean sticky;
    protected static boolean changingWorld = false;

    protected MultiPistonBase(boolean sticky) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_60978_(0.5f).m_60918_(SoundType.f_56743_));
        String name = "multi_piston" + (sticky ? "_sticky" : "");
        this.setRegistryName(name);
        this.sticky = sticky;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ESProperties.FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false)));
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ESProperties.FACING, ESProperties.EXTENDED, ESProperties.SHIFTING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ESProperties.FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tt.essentials.multi_piston.desc", new Object[]{15, 64}));
        tooltip.add((Component)new TranslatableComponent("tt.essentials.multi_piston.reds"));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)ESProperties.EXTENDED)).booleanValue()) {
            return BB[((Direction)state.m_61143_((Property)ESProperties.FACING)).m_122411_()];
        }
        return Shapes.m_83144_();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockState otherState;
        if (!changingWorld && (newState.m_60734_() != this || state.m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false)) != newState.m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false))) && ((Boolean)state.m_61143_((Property)ESProperties.EXTENDED)).booleanValue() && (otherState = world.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)ESProperties.FACING)))).m_60734_() == (this.sticky ? ESBlocks.multiPistonExtendSticky : ESBlocks.multiPistonExtend) && otherState.m_61143_(ESProperties.AXIS) == ((Direction)state.m_61143_((Property)ESProperties.FACING)).m_122434_()) {
            world.m_46961_(pos.m_142300_((Direction)state.m_61143_((Property)ESProperties.FACING)), false);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (ESConfig.isWrench(playerIn.m_21120_(hand)) && !((Boolean)state.m_61143_((Property)ESProperties.EXTENDED)).booleanValue() && !((Boolean)state.m_61143_((Property)ESProperties.SHIFTING)).booleanValue()) {
            if (!worldIn.f_46443_) {
                BlockState endState = (BlockState)state.m_61122_((Property)ESProperties.FACING);
                worldIn.m_46597_(pos, endState);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public PushReaction m_5537_(BlockState state) {
        return (Boolean)state.m_61143_((Property)ESProperties.EXTENDED) != false || (Boolean)state.m_61143_((Property)ESProperties.SHIFTING) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)ESProperties.SHIFTING)).booleanValue()) {
            double particleRad = 0.75;
            for (int i = 0; i < 4; ++i) {
                worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + rand.nextGaussian() * particleRad, (double)pos.m_123342_() + 0.5 + rand.nextGaussian() * particleRad, (double)pos.m_123343_() + 0.5 + rand.nextGaussian() * particleRad, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.m_6861_(world.m_8055_(pos), world, pos, this, pos, false);
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        int currExtend;
        if (worldIn.f_46443_ || changingWorld || ((Boolean)state.m_61143_((Property)ESProperties.SHIFTING)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ESProperties.FACING);
        int redstone = this.getRedstoneInput(worldIn, pos, state, facing);
        if (redstone > (currExtend = this.getCurrentExtension(worldIn, pos, state, facing))) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.m_6219_().m_7663_(pos, (Object)this, 2, TickPriority.NORMAL);
            this.playSound(worldIn, pos, false, true);
        } else {
            this.m_7458_(state, (ServerLevel)worldIn, pos, worldIn.f_46441_);
        }
    }

    private int getRedstoneInput(Level world, BlockPos pos, BlockState state, Direction facing) {
        int target = 0;
        for (Direction dir : Direction.values()) {
            if (dir == facing) continue;
            target = Math.max(target, RedstoneUtil.getRedstoneOnSide(world, pos, dir));
        }
        if (facing == Direction.UP) {
            target = Math.min(target, world.m_151558_() - pos.m_123342_() - 1);
        } else if (facing == Direction.DOWN) {
            target = Math.min(target, pos.m_123342_() - world.m_141937_());
        }
        return target;
    }

    private void playSound(Level world, BlockPos pos, boolean moving, boolean extension) {
        if (moving) {
            world.m_5594_(null, pos, extension ? SoundEvents.f_12312_ : SoundEvents.f_12311_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            world.m_5594_(null, pos, SoundEvents.f_12067_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private int getCurrentExtension(Level world, BlockPos pos, BlockState state, Direction facing) {
        int currentExtension = 0;
        if (((Boolean)state.m_61143_((Property)ESProperties.EXTENDED)).booleanValue()) {
            Direction.AxisDirection dir;
            BlockPos checkPos = pos.m_142300_(facing);
            BlockState curState = world.m_8055_(checkPos);
            Block tarBlock = this.getExtensionBlock(this.sticky);
            while (curState.m_60734_() == tarBlock && curState.m_61143_(ESProperties.AXIS) == facing.m_122434_() && (dir = MultiPistonExtend.getDirFromHead((Integer)curState.m_61143_((Property)ESProperties.HEAD))) != facing.m_122424_().m_122421_() && currentExtension != 15) {
                ++currentExtension;
                checkPos = checkPos.m_142300_(facing);
                curState = world.m_8055_(checkPos);
                if (dir == null) continue;
                break;
            }
        }
        return currentExtension;
    }

    private Block getExtensionBlock(boolean sticky) {
        if (sticky) {
            return ESBlocks.multiPistonExtendSticky;
        }
        return ESBlocks.multiPistonExtend;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        Direction facing = (Direction)state.m_61143_((Property)ESProperties.FACING);
        int redstone = this.getRedstoneInput((Level)world, pos, state, facing);
        int currExtend = this.getCurrentExtension((Level)world, pos, state, facing);
        state = (BlockState)state.m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(false));
        world.m_7731_(pos, state, 2);
        if (currExtend == redstone) {
            return;
        }
        changingWorld = true;
        WorldBuffer wBuf = new WorldBuffer((Level)world);
        if (currExtend < redstone) {
            boolean blocked = this.shiftExtension(wBuf, pos, facing, currExtend, true);
            if (!blocked && currExtend + 1 < redstone) {
                state = (BlockState)state.m_61124_((Property)ESProperties.SHIFTING, (Comparable)Boolean.valueOf(true));
                world.m_7731_(pos, state, 2);
                world.m_6219_().m_7663_(pos, (Object)this, 2, TickPriority.NORMAL);
            }
            Set<BlockPos> toUpdate = wBuf.changedPositions();
            wBuf.applyChanges(67);
            for (BlockPos posToUpdate : toUpdate) {
                world.m_46672_(posToUpdate, (Block)this);
            }
            if (!blocked) {
                this.playSound((Level)world, pos, true, true);
                state = (BlockState)state.m_61124_((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(redstone != 0));
                world.m_7731_(pos, state, 2);
            }
        } else {
            for (int i = currExtend; i > redstone; --i) {
                this.shiftExtension(wBuf, pos, facing, i, false);
            }
            Set<BlockPos> toUpdate = wBuf.changedPositions();
            wBuf.applyChanges(67);
            for (BlockPos posToUpdate : toUpdate) {
                world.m_46672_(posToUpdate, (Block)this);
            }
            this.playSound((Level)world, pos, true, false);
            state = (BlockState)state.m_61124_((Property)ESProperties.EXTENDED, (Comparable)Boolean.valueOf(redstone != 0));
            world.m_7731_(pos, state, 2);
        }
        changingWorld = false;
    }

    private boolean shiftExtension(WorldBuffer world, BlockPos pos, Direction facing, int currentExtension, boolean out) {
        Direction moveDir = out ? facing : facing.m_122424_();
        LinkedHashSet<BlockPos> movedBlocks = new LinkedHashSet<BlockPos>(65);
        BlockPos prevHeadPos = pos.m_5484_(facing, currentExtension);
        Block extendBlock = this.getExtensionBlock(this.sticky);
        if (!out) {
            movedBlocks.add(prevHeadPos);
        }
        if ((out || this.sticky) && this.buildMoveset(pos, world, prevHeadPos.m_142300_(facing), moveDir, movedBlocks, !out)) {
            if (!out) {
                movedBlocks.clear();
            } else {
                return true;
            }
        }
        if (!out) {
            movedBlocks.remove(prevHeadPos);
        }
        if (currentExtension != 0) {
            world.addChange(prevHeadPos, out ? (BlockState)extendBlock.m_49966_().m_61124_(ESProperties.AXIS, (Comparable)facing.m_122434_()) : Blocks.f_50016_.m_49966_());
        }
        for (BlockPos changePos : movedBlocks) {
            BlockState prevState = world.m_8055_(changePos);
            if (prevState.m_60811_() == PushReaction.DESTROY) {
                world.getWorld().m_46961_(changePos, true);
            } else {
                world.addChange(changePos.m_142300_(moveDir), prevState);
            }
            world.addChange(changePos, Blocks.f_50016_.m_49966_());
            this.moveEnts(world.getWorld(), changePos, moveDir, prevState.isSlimeBlock());
        }
        this.moveEnts(world.getWorld(), prevHeadPos, moveDir, false);
        if (out) {
            world.addChange(pos.m_5484_(facing, currentExtension + 1), (BlockState)((BlockState)extendBlock.m_49966_().m_61124_(ESProperties.AXIS, (Comparable)facing.m_122434_())).m_61124_((Property)ESProperties.HEAD, (Comparable)Integer.valueOf(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : 2)));
        } else if (currentExtension != 1) {
            world.addChange(pos.m_5484_(facing, currentExtension - 1), (BlockState)((BlockState)extendBlock.m_49966_().m_61124_(ESProperties.AXIS, (Comparable)facing.m_122434_())).m_61124_((Property)ESProperties.HEAD, (Comparable)Integer.valueOf(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : 2)));
        }
        return false;
    }

    private void moveEnts(Level world, BlockPos activePos, Direction moveDir, boolean sticky) {
        AABB BB = new AABB(activePos.m_142300_(moveDir));
        ArrayList<Entity> movingEnts = new ArrayList<Entity>(4);
        MultiPistonBase.getEntitiesMultiChunk(BB, world, movingEnts);
        for (Entity ent : movingEnts) {
            if (ent.m_7752_() == PushReaction.IGNORE) continue;
            ent.m_6021_(ent.m_20185_() + (double)moveDir.m_122429_(), ent.m_20186_() + (double)moveDir.m_122430_(), ent.m_20189_() + (double)moveDir.m_122431_());
            if (!sticky) continue;
            ent.m_5997_((double)moveDir.m_122429_(), (double)moveDir.m_122430_(), (double)moveDir.m_122431_());
            ent.f_19864_ = true;
        }
        movingEnts.clear();
    }

    private boolean buildMoveset(BlockPos pistonPos, WorldBuffer world, BlockPos curPos, Direction moveDir, LinkedHashSet<BlockPos> movedBlocks, boolean dragging) {
        if (movedBlocks.contains(curPos)) {
            return false;
        }
        BlockState state = world.m_8055_(curPos);
        PushReaction reaction = state.m_60811_();
        if (state.m_60795_()) {
            reaction = PushReaction.IGNORE;
        } else if (state.m_60734_() == Blocks.f_50080_ || state.m_60734_() instanceof EntityBlock || pistonPos.equals((Object)curPos)) {
            reaction = PushReaction.BLOCK;
        } else if (state.m_60800_((BlockGetter)world, curPos) < 0.0f) {
            reaction = PushReaction.BLOCK;
        } else if (state.m_60734_() instanceof PistonBaseBlock && state.m_61138_((Property)PistonBaseBlock.f_60153_)) {
            reaction = (Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
        }
        boolean blocked = false;
        switch (reaction) {
            case PUSH_ONLY: {
                if (dragging) break;
            }
            case NORMAL: {
                if (moveDir == Direction.UP && curPos.m_123342_() == world.getWorld().m_151558_() || moveDir == Direction.DOWN && curPos.m_123342_() == 0) {
                    blocked = true;
                    break;
                }
                movedBlocks.add(curPos);
                blocked = movedBlocks.size() > 64 || this.buildMoveset(pistonPos, world, curPos.m_142300_(moveDir), moveDir, movedBlocks, false);
                movedBlocks.remove(curPos);
                movedBlocks.add(curPos);
                if (state.isStickyBlock() && state.canStickTo(world.m_8055_(curPos.m_142300_(moveDir.m_122424_())))) {
                    boolean bl = blocked = blocked || this.buildMoveset(pistonPos, world, curPos.m_142300_(moveDir.m_122424_()), moveDir, movedBlocks, true);
                }
                if (!state.isStickyBlock()) break;
                for (Direction side : Direction.values()) {
                    if (side.m_122434_() == moveDir.m_122434_() || !state.canStickTo(world.m_8055_(curPos.m_142300_(side)))) continue;
                    blocked = blocked || this.buildMoveset(pistonPos, world, curPos.m_142300_(side), moveDir, movedBlocks, true);
                }
                break;
            }
            case DESTROY: {
                if (dragging) break;
                movedBlocks.add(curPos);
                break;
            }
            case BLOCK: {
                blocked = !dragging;
                break;
            }
        }
        return blocked || movedBlocks.size() > 64;
    }

    private static void getEntitiesMultiChunk(AABB checkBox, Level worldIn, ArrayList<Entity> entList) {
        entList.addAll(worldIn.m_45933_(null, checkBox));
    }
}

