/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractCircuit
extends AbstractTile {
    protected AbstractCircuit(String name) {
        super(name);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ESProperties.HORIZ_FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (ESConfig.isWrench(playerIn.m_21120_(hand))) {
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING)).m_122427_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CircuitTileEntity(pos, state);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity && !worldIn.f_46443_) {
            CircuitTileEntity cte = (CircuitTileEntity)te;
            cte.builtConnections = false;
            cte.buildConnections();
        } else {
            worldIn.m_6219_().m_7663_(pos, (Object)this, 2, TickPriority.VERY_HIGH);
        }
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity) {
            CircuitTileEntity cte = (CircuitTileEntity)te;
            if (blockIn == Blocks.f_50088_ || blockIn instanceof DiodeBlock) {
                cte.handleInputChange(TickPriority.HIGH);
            } else {
                cte.builtConnections = false;
            }
            cte.buildConnections();
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity te;
        if (side.m_122424_() == state.m_61143_((Property)ESProperties.HORIZ_FACING) && (te = blockAccess.m_7702_(pos)) instanceof CircuitTileEntity) {
            return RedstoneUtil.clampToVanilla(((CircuitTileEntity)te).getOutput());
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return side != null && (side.m_122424_() == state.m_61143_((Property)ESProperties.HORIZ_FACING) || this.useInput(CircuitTileEntity.Orient.getOrient(side.m_122424_(), (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING))));
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof CircuitTileEntity) {
            ((CircuitTileEntity)te).recalculateOutput();
        }
    }

    @Override
    public boolean canConnect(Direction side, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)ESProperties.HORIZ_FACING);
        return side == facing || this.useInput(CircuitTileEntity.Orient.getOrient(side, facing));
    }

    @Override
    public boolean usesQuartz() {
        return true;
    }

    public abstract boolean useInput(CircuitTileEntity.Orient var1);

    public abstract float getOutput(float var1, float var2, float var3, CircuitTileEntity var4);
}

