/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.AutoCrafterScreen;
import com.Da_Technomancer.essentials.tileentities.AutoCrafterTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class AutoCrafterContainer
extends RecipeBookMenu<CraftingContainer> {
    @ObjectHolder(value="auto_crafter")
    private static MenuType<AutoCrafterContainer> TYPE = null;
    @Nullable
    public final AutoCrafterTileEntity te;
    private final Container inv;
    private final Inventory playerInv;

    public AutoCrafterContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(TYPE, id, playerInventory, data);
    }

    protected AutoCrafterContainer(MenuType<? extends AutoCrafterContainer> type, int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(type, id, playerInventory, (Container)new SimpleContainer(19), data.m_130135_());
    }

    public AutoCrafterContainer(int id, Inventory playerInventory, Container inv, BlockPos pos) {
        this(TYPE, id, playerInventory, inv, pos);
    }

    protected AutoCrafterContainer(MenuType<? extends AutoCrafterContainer> type, int id, Inventory playerInventory, final Container inv, BlockPos pos) {
        super(type, id);
        int i;
        this.playerInv = playerInventory;
        BlockEntity getTe = playerInventory.f_35978_.f_19853_.m_7702_(pos);
        this.te = getTe instanceof AutoCrafterTileEntity ? (AutoCrafterTileEntity)getTe : null;
        this.inv = inv;
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(inv, i, 8 + i * 18, 73){

                public boolean m_5857_(ItemStack stack) {
                    if (AutoCrafterContainer.this.te == null) {
                        return false;
                    }
                    int freeSlots = AutoCrafterContainer.this.te.getLegalSlots(stack.m_41720_(), inv, AutoCrafterContainer.this) - AutoCrafterContainer.this.te.getUsedSlots(stack.m_41720_(), inv);
                    return freeSlots > 0 || freeSlots == 0 && BlockUtil.sameItem(this.m_7993_(), stack);
                }
            });
        }
        this.m_38897_(new Slot(inv, 9, 133, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new GhostRecipeSlot(inv, 10 + i, 44 + 18 * (i % 3), 15 + 18 * (i / 3)));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 162));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 104 + i * 18));
            }
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inv.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int fromSlot) {
        ItemStack previous = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(fromSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            previous = current.m_41777_();
            if (fromSlot < 10 ? !this.m_38903_(current, 10, 46, true) : !this.m_38903_(current, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (current.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (current.m_41613_() == previous.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, current);
        }
        return previous;
    }

    public void m_6951_(boolean p_217056_1_, Recipe<?> rec, ServerPlayer player) {
        if (this.te != null) {
            this.te.setRecipe(rec);
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId > 9 && slotId < 19 && player != null && this.te != null) {
            if (this.playerInv.m_36056_().m_41619_()) {
                Recipe<CraftingContainer> rec = this.te.validateRecipe(AutoCrafterTileEntity.lookupRecipe(this.te.getRecipeManager(), this.te.recipe), this);
                if (rec == null) {
                    this.inv.m_8016_(slotId);
                } else {
                    int width;
                    NonNullList ingr = rec.m_7527_();
                    int index = slotId - 10;
                    int n = width = rec instanceof IShapedRecipe ? ((IShapedRecipe)rec).getRecipeWidth() : 3;
                    if (index % 3 < width && !((Ingredient)ingr.get(index - (3 - width) * (index / 3))).m_43947_()) {
                        if (player.f_19853_.f_46443_) {
                            this.te.recipe = null;
                        } else {
                            this.te.setRecipe(null);
                        }
                        this.inv.m_8016_(slotId);
                    }
                }
            } else {
                if (player.f_19853_.f_46443_) {
                    this.te.recipe = null;
                } else {
                    this.te.setRecipe(null);
                }
                ItemStack s = this.playerInv.m_36056_().m_41777_();
                s.m_41764_(1);
                this.inv.m_6836_(slotId, s);
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public List<RecipeBookCategories> getRecipeBookCategories() {
        return AutoCrafterScreen.getRecipeCategories();
    }

    @OnlyIn(value=Dist.CLIENT)
    public RecipeBookType m_5867_() {
        return RecipeBookType.CRAFTING;
    }

    public boolean m_142157_(int slot) {
        return slot != this.m_6636_();
    }

    public void m_5816_(StackedContents recipeHelper) {
    }

    public void m_6650_() {
    }

    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return false;
    }

    public int m_6636_() {
        return 9;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 3;
    }

    public int m_6653_() {
        return 10;
    }

    public static class GhostRecipeSlot
    extends Slot {
        private GhostRecipeSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }

        public int m_6641_() {
            return 0;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

