/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FluidSlotManager {
    private static BiMap<ResourceLocation, Short> fluidIDs = null;
    private final int capacity;
    private int fluidId;
    private int fluidQty;
    private final ArrayList<WeakReference<Slot>> fluidItemInSlots = new ArrayList(1);
    private int windowXStart;
    private int windowYStart;
    private int xPos;
    private int yPos;
    private DataSlot idRef;
    private DataSlot qtyRef;
    private static final int MAX_HEIGHT = 48;
    private static final ResourceLocation OVERLAY = new ResourceLocation("essentials", "textures/gui/rectangle_fluid_overlay.png");

    private static BiMap<ResourceLocation, Short> getFluidMap() {
        if (fluidIDs == null) {
            fluidIDs = HashBiMap.create((int)ForgeRegistries.FLUIDS.getKeys().size());
            short[] value = new short[]{0};
            ForgeRegistries.FLUIDS.getKeys().stream().sorted(ResourceLocation::compareTo).forEach(key -> {
                short s = value[0];
                value[0] = (short)(s + 1);
                fluidIDs.put(key, (Object)s);
            });
        }
        return fluidIDs;
    }

    public FluidSlotManager(FluidStack init, int capacity) {
        this.capacity = capacity;
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)init.getFluid().getRegistryName(), (Object)-1)).shortValue();
        this.fluidQty = init.getAmount() - Short.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initScreen(int windowXStart, int windowYStart, int xPos, int yPos, DataSlot idRef, DataSlot qtyRef) {
        this.windowXStart = windowXStart;
        this.windowYStart = windowYStart;
        this.xPos = xPos;
        this.yPos = yPos;
        this.idRef = idRef;
        this.qtyRef = qtyRef;
        this.idRef.m_6422_(this.fluidId);
        this.qtyRef.m_6422_(this.fluidQty);
    }

    public void linkSlot(Slot fluidItemInputSlot) {
        this.fluidItemInSlots.add(new WeakReference<Slot>(fluidItemInputSlot));
    }

    public int getFluidId() {
        return this.fluidId;
    }

    public int getFluidQty() {
        return this.fluidQty;
    }

    public void updateState(FluidStack newFluid) {
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)newFluid.getFluid().getRegistryName(), (Object)-1)).shortValue();
        this.fluidQty = newFluid.getAmount() - Short.MAX_VALUE;
        for (int index = 0; index < this.fluidItemInSlots.size(); ++index) {
            Slot contents = (Slot)this.fluidItemInSlots.get(index).get();
            if (contents == null) {
                this.fluidItemInSlots.remove(index);
                --index;
                continue;
            }
            contents.m_6654_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getStack() {
        short fluidId = (short)this.idRef.m_6501_();
        if (fluidId < 0) {
            return FluidStack.EMPTY;
        }
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue((ResourceLocation)FluidSlotManager.getFluidMap().inverse().getOrDefault((Object)fluidId, (Object)Fluids.f_76193_.getRegistryName()));
        if (f == null) {
            f = Fluids.f_76193_;
        }
        return new FluidStack(f, this.qtyRef.m_6501_() + Short.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack matrix, float partialTicks, int mouseX, int mouseY, Font fontRenderer, List<Component> tooltip) {
        FluidStack clientState = this.getStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Screen.m_93172_((PoseStack)matrix, (int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - 48), (int)(this.xPos + this.windowXStart + 16), (int)(this.yPos + this.windowYStart), (int)-6974059);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidAttributes attr = clientState.getFluid().getAttributes();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(attr.getStillTexture());
        int col = attr.getColor(clientState);
        int height = (int)(48.0f * (float)clientState.getAmount() / (float)this.capacity);
        RenderSystem.m_157429_((float)((float)(col >>> 16 & 0xFF) / 255.0f), (float)((float)(col >>> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
        Screen.m_93200_((PoseStack)matrix, (int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - height), (int)0, (int)16, (int)height, (TextureAtlasSprite)sprite);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY);
        Screen.m_93133_((PoseStack)matrix, (int)(this.windowXStart + this.xPos), (int)(this.windowYStart + this.yPos - 48), (float)0.0f, (float)0.0f, (int)16, (int)48, (int)16, (int)48);
        if (mouseX >= this.xPos + this.windowXStart && mouseX <= this.xPos + this.windowXStart + 16 && mouseY >= this.yPos + this.windowYStart - 48 && mouseY <= this.yPos + this.windowYStart) {
            if (clientState.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent("tt.essentials.fluid_contents.empty"));
            } else {
                tooltip.add(clientState.getDisplayName());
            }
            tooltip.add((Component)new TranslatableComponent("tt.essentials.fluid_contents", new Object[]{clientState.getAmount(), this.capacity}));
        }
    }

    public static Pair<Slot, Slot> createFluidSlots(Container inv, int startIndex, int inXPos, int inYPos, int outXPos, int outYPos, @Nullable IFluidSlotTE te, int[] fluidIndex) {
        InSlot in = new InSlot(inv, startIndex + 1, inXPos, inYPos, startIndex, te, fluidIndex);
        OutSlot out = new OutSlot(inv, startIndex, outXPos, outYPos, in);
        return Pair.of((Object)((Object)out), (Object)((Object)in));
    }

    private static class InSlot
    extends Slot {
        private final int outSlotIndex;
        @Nullable
        private final IFluidSlotTE te;
        private final int[] fluidIndices;
        private boolean internalChange = false;

        private InSlot(Container inventoryIn, int index, int xPosition, int yPosition, int outSlotIndex, @Nullable IFluidSlotTE te, int[] fluidIndices) {
            super(inventoryIn, index, xPosition, yPosition);
            this.outSlotIndex = outSlotIndex;
            this.te = te;
            this.fluidIndices = fluidIndices;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public void m_6654_() {
            super.m_6654_();
            ItemStack inSlot = this.m_7993_();
            if (!this.internalChange && this.te != null && this.m_5857_(inSlot)) {
                this.internalChange = true;
                ItemStack outSlot = this.f_40218_.m_8020_(this.outSlotIndex);
                ItemStack inSlotCopy = inSlot.m_41777_();
                inSlotCopy.m_41764_(1);
                LazyOptional opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                IFluidHandler teHandler = this.te.getFluidHandler();
                if (opt.isPresent()) {
                    IFluidHandlerItem itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                    if (outSlot.m_41619_()) {
                        for (int fluidIndex : this.fluidIndices) {
                            FluidStack filled;
                            int filledQty;
                            int drainQty = teHandler.getTankCapacity(fluidIndex) - teHandler.getFluidInTank(fluidIndex).getAmount();
                            FluidStack drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.SIMULATE);
                            if (teHandler.isFluidValid(fluidIndex, drained)) {
                                drainQty = teHandler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                                drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.EXECUTE);
                                if ((drainQty = drained.getAmount()) > 0) {
                                    teHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                                    this.f_40218_.m_6836_(this.outSlotIndex, itemHandler.getContainer());
                                    inSlot.m_41774_(1);
                                    this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                                    this.f_40218_.m_6596_();
                                    this.internalChange = false;
                                    return;
                                }
                            }
                            if ((filledQty = itemHandler.fill(filled = teHandler.drain(0x3FFFFFFF, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                            filled.setAmount(filledQty);
                            teHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            this.f_40218_.m_6836_(this.outSlotIndex, itemHandler.getContainer());
                            inSlot.m_41774_(1);
                            this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                            this.internalChange = false;
                            return;
                        }
                    } else {
                        for (int fluidIndex : this.fluidIndices) {
                            int drainQty = teHandler.getTankCapacity(fluidIndex) - teHandler.getFluidInTank(fluidIndex).getAmount();
                            FluidStack drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.SIMULATE);
                            if (teHandler.isFluidValid(fluidIndex, drained)) {
                                drainQty = teHandler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                                drained = itemHandler.drain(drainQty, IFluidHandler.FluidAction.EXECUTE);
                                drainQty = drained.getAmount();
                                ItemStack containerResult = itemHandler.getContainer();
                                if (drainQty > 0 && (containerResult.m_41619_() || BlockUtil.sameItem(containerResult, outSlot) && outSlot.m_41613_() + containerResult.m_41613_() <= containerResult.m_41741_())) {
                                    teHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                                    outSlot.m_41769_(containerResult.m_41613_());
                                    this.f_40218_.m_6836_(this.outSlotIndex, outSlot);
                                    inSlot.m_41774_(1);
                                    this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                                    this.f_40218_.m_6596_();
                                    this.internalChange = false;
                                    return;
                                }
                                inSlotCopy = inSlot.m_41777_();
                                inSlotCopy.m_41764_(1);
                                opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                                itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                                this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                            }
                            FluidStack filled = teHandler.drain(0x3FFFFFFF, IFluidHandler.FluidAction.SIMULATE);
                            int filledQty = itemHandler.fill(filled, IFluidHandler.FluidAction.EXECUTE);
                            ItemStack containerResult = itemHandler.getContainer();
                            if (filledQty > 0 && (containerResult.m_41619_() || BlockUtil.sameItem(containerResult, outSlot) && outSlot.m_41613_() + containerResult.m_41613_() <= containerResult.m_41741_())) {
                                filled.setAmount(filledQty);
                                teHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                                outSlot.m_41769_(containerResult.m_41613_());
                                this.f_40218_.m_6836_(this.outSlotIndex, outSlot);
                                inSlot.m_41774_(1);
                                this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                                this.internalChange = false;
                                return;
                            }
                            inSlotCopy = inSlot.m_41777_();
                            inSlotCopy.m_41764_(1);
                            opt = inSlotCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                            itemHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                            this.f_40218_.m_6836_(this.getSlotIndex(), inSlot);
                        }
                    }
                }
                this.internalChange = false;
            }
        }
    }

    private static class OutSlot
    extends Slot {
        private final InSlot inSlot;

        private OutSlot(Container inventoryIn, int index, int xPosition, int yPosition, InSlot inSlot) {
            super(inventoryIn, index, xPosition, yPosition);
            this.inSlot = inSlot;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            this.inSlot.m_6654_();
        }
    }

    public static class FakeInventory
    implements Container {
        private final AbstractContainerMenu container;
        private final ItemStack[] stacks = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_};

        public FakeInventory(AbstractContainerMenu cont) {
            this.container = cont;
        }

        public int m_6643_() {
            return 2;
        }

        public boolean m_7983_() {
            return this.stacks[0].m_41619_() && this.stacks[1].m_41619_();
        }

        public ItemStack m_8020_(int index) {
            return this.stacks[index];
        }

        public ItemStack m_7407_(int index, int count) {
            this.m_6596_();
            return this.stacks[index].m_41620_(count);
        }

        public ItemStack m_8016_(int index) {
            ItemStack stack = this.stacks[index];
            this.stacks[index] = ItemStack.f_41583_;
            this.m_6596_();
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stacks[index] = stack;
            this.m_6596_();
        }

        public int m_6893_() {
            return 64;
        }

        public void m_6596_() {
            this.container.m_38946_();
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return index == 0 && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public void m_6211_() {
            this.stacks[0] = ItemStack.f_41583_;
            this.stacks[1] = ItemStack.f_41583_;
            this.m_6596_();
        }
    }
}

