/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.tileentities.SlottedChestTileEntity;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class SlottedChestContainer
extends AbstractContainerMenu {
    @ObjectHolder(value="slotted_chest")
    private static MenuType<SlottedChestContainer> TYPE = null;
    public final SlottedChestTileEntity.SlottedInv inv;
    public final ItemStack[] filter;
    @Nullable
    private static ItemStack[] filtTrans;
    private int dragEvent;
    private final Set<Slot> dragSlots;
    private int dragMode;

    public SlottedChestContainer(int id, Inventory playerInventory, FriendlyByteBuf data) {
        filtTrans = SlottedChestContainer.decodeBuffer(data);
        this(id, playerInventory, new SlottedChestTileEntity.SlottedInv(new ItemStack[54], filtTrans, null), filtTrans);
    }

    private static ItemStack[] decodeBuffer(FriendlyByteBuf buf) {
        if (buf == null) {
            Essentials.logger.warn("Received empty data for SlottedChest! This is a bug!");
            ItemStack[] filter = new ItemStack[54];
            for (int i = 0; i < 54; ++i) {
                filter[i] = ItemStack.f_41583_;
            }
            return filter;
        }
        ItemStack[] filter = new ItemStack[54];
        for (int i = 0; i < 54; ++i) {
            filter[i] = buf.m_130267_();
        }
        return filter;
    }

    public SlottedChestContainer(int id, Inventory playerInventory, SlottedChestTileEntity.SlottedInv inv, ItemStack[] filter) {
        super(TYPE, id);
        this.dragSlots = Sets.newHashSet();
        this.dragMode = -1;
        this.filter = filter;
        this.inv = inv;
        int numRows = inv.m_6643_() / 9;
        int i = (numRows - 4) * 18;
        for (int j = 0; j < numRows; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inv, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInventory, j1 + l * 9 + 9, 8 + j1 * 18, 103 + l * 18 + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 161 + i));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inv.m_6542_(playerIn);
    }

    protected void m_38951_() {
        super.m_38951_();
        this.dragEvent = 0;
        this.dragSlots.clear();
    }

    private void doClick(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack itemstack = ItemStack.f_41583_;
        Inventory inventoryplayer = player.m_150109_();
        if (clickTypeIn == ClickType.QUICK_CRAFT) {
            int i = this.dragEvent;
            this.dragEvent = SlottedChestContainer.m_38947_((int)dragType);
            if ((i != 1 || this.dragEvent != 2) && i != this.dragEvent) {
                this.m_38951_();
            } else if (this.m_142621_().m_41619_()) {
                this.m_38951_();
            } else if (this.dragEvent == 0) {
                this.dragMode = SlottedChestContainer.m_38928_((int)dragType);
                if (SlottedChestContainer.m_38862_((int)this.dragMode, (Player)player)) {
                    this.dragEvent = 1;
                    this.dragSlots.clear();
                } else {
                    this.m_38951_();
                }
            } else if (this.dragEvent == 1) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                ItemStack itemstack1 = this.m_142621_();
                if (slot != null && this.canAddItemToSlotLocked(slot, itemstack1, true) && slot.m_5857_(itemstack1) && (this.dragMode == 2 || itemstack1.m_41613_() > this.dragSlots.size()) && this.m_5622_(slot)) {
                    this.dragSlots.add(slot);
                }
            } else if (this.dragEvent == 2) {
                if (!this.dragSlots.isEmpty()) {
                    ItemStack itemstack5 = this.m_142621_().m_41777_();
                    int l = this.m_142621_().m_41613_();
                    for (Slot slot1 : this.dragSlots) {
                        ItemStack itemstack2 = this.m_142621_();
                        if (slot1 == null || !this.canAddItemToSlotLocked(slot1, itemstack2, true) || !slot1.m_5857_(itemstack2) || this.dragMode != 2 && itemstack2.m_41613_() < this.dragSlots.size() || !this.m_5622_(slot1)) continue;
                        ItemStack itemstack3 = itemstack5.m_41777_();
                        int j = slot1.m_6657_() ? slot1.m_7993_().m_41613_() : 0;
                        SlottedChestContainer.m_38922_(this.dragSlots, (int)this.dragMode, (ItemStack)itemstack3, (int)j);
                        int k = Math.min(itemstack3.m_41741_(), slot1.m_5866_(itemstack3));
                        if (itemstack3.m_41613_() > k) {
                            itemstack3.m_41764_(k);
                        }
                        l -= itemstack3.m_41613_() - j;
                        slot1.m_5852_(itemstack3);
                        if (!(slot1.f_40218_ instanceof SlottedChestTileEntity.SlottedInv) || !this.filter[slot1.getSlotIndex()].m_41619_()) continue;
                        this.filter[slot1.getSlotIndex()] = slot1.m_7993_().m_41777_();
                        this.filter[slot1.getSlotIndex()].m_41764_(1);
                        this.inv.filterChanged();
                    }
                    itemstack5.m_41764_(l);
                    this.m_142503_(itemstack5);
                }
                this.m_38951_();
            } else {
                this.m_38951_();
            }
        } else if (this.dragEvent != 0) {
            this.m_38951_();
        } else if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            if (slotId == -999) {
                if (!this.m_142621_().m_41619_()) {
                    if (dragType == 0) {
                        player.m_36176_(this.m_142621_(), true);
                        this.m_142503_(ItemStack.f_41583_);
                    }
                    if (dragType == 1) {
                        player.m_36176_(this.m_142621_().m_41620_(1), true);
                    }
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                ItemStack itemstack10;
                if (slotId < 0) {
                    return;
                }
                Slot slot6 = (Slot)this.f_38839_.get(slotId);
                if (slot6.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && !slot6.m_6657_()) {
                    this.filter[slot6.getSlotIndex()] = ItemStack.f_41583_;
                    this.inv.filterChanged();
                }
                if (slot6.m_8010_(player) && !(itemstack10 = this.m_7648_(player, slotId)).m_41619_()) {
                    itemstack = itemstack10.m_41777_();
                }
            } else {
                if (slotId < 0) {
                    return;
                }
                Slot slot7 = (Slot)this.f_38839_.get(slotId);
                if (slot7 != null) {
                    ItemStack itemstack11 = slot7.m_7993_();
                    ItemStack itemstack13 = this.m_142621_();
                    if (!itemstack11.m_41619_()) {
                        itemstack = itemstack11.m_41777_();
                    }
                    if (itemstack11.m_41619_()) {
                        if (!itemstack13.m_41619_() && slot7.m_5857_(itemstack13) && this.canAddItemToSlotLocked(slot7, itemstack13, false)) {
                            int l2;
                            int n = l2 = dragType == 0 ? itemstack13.m_41613_() : 1;
                            if (l2 > slot7.m_5866_(itemstack13)) {
                                l2 = slot7.m_5866_(itemstack13);
                            }
                            slot7.m_5852_(itemstack13.m_41620_(l2));
                            if (slot7.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot7.getSlotIndex()].m_41619_()) {
                                this.filter[slot7.getSlotIndex()] = slot7.m_7993_().m_41777_();
                                this.filter[slot7.getSlotIndex()].m_41764_(1);
                                this.inv.filterChanged();
                            }
                        }
                    } else if (slot7.m_8010_(player)) {
                        int i2;
                        if (itemstack13.m_41619_()) {
                            if (itemstack11.m_41619_()) {
                                slot7.m_5852_(ItemStack.f_41583_);
                                this.m_142503_(ItemStack.f_41583_);
                            } else {
                                int k2 = dragType == 0 ? itemstack11.m_41613_() : (itemstack11.m_41613_() + 1) / 2;
                                this.m_142503_(slot7.m_6201_(k2));
                                if (itemstack11.m_41619_()) {
                                    slot7.m_5852_(ItemStack.f_41583_);
                                }
                                slot7.m_142406_(player, this.m_142621_());
                            }
                        } else if (slot7.m_5857_(itemstack13)) {
                            if (itemstack11.m_41720_() == itemstack13.m_41720_() && ItemStack.m_41658_((ItemStack)itemstack11, (ItemStack)itemstack13)) {
                                int j2;
                                int n = j2 = dragType == 0 ? itemstack13.m_41613_() : 1;
                                if (j2 > slot7.m_5866_(itemstack13) - itemstack11.m_41613_()) {
                                    j2 = slot7.m_5866_(itemstack13) - itemstack11.m_41613_();
                                }
                                if (j2 > itemstack13.m_41741_() - itemstack11.m_41613_()) {
                                    j2 = itemstack13.m_41741_() - itemstack11.m_41613_();
                                }
                                itemstack13.m_41774_(j2);
                                itemstack11.m_41769_(j2);
                            } else if (itemstack13.m_41613_() <= slot7.m_5866_(itemstack13)) {
                                slot7.m_5852_(itemstack13);
                                if (slot7.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot7.getSlotIndex()].m_41619_()) {
                                    this.filter[slot7.getSlotIndex()] = slot7.m_7993_().m_41777_();
                                    this.filter[slot7.getSlotIndex()].m_41764_(1);
                                    this.inv.filterChanged();
                                }
                                this.m_142503_(itemstack11);
                            }
                        } else if (itemstack11.m_41720_() == itemstack13.m_41720_() && itemstack13.m_41741_() > 1 && ItemStack.m_41658_((ItemStack)itemstack11, (ItemStack)itemstack13) && !itemstack11.m_41619_() && (i2 = itemstack11.m_41613_()) + itemstack13.m_41613_() <= itemstack13.m_41741_()) {
                            itemstack13.m_41769_(i2);
                            itemstack11 = slot7.m_6201_(i2);
                            if (itemstack11.m_41619_()) {
                                slot7.m_5852_(ItemStack.f_41583_);
                            }
                            slot7.m_142406_(player, this.m_142621_());
                        }
                    }
                    slot7.m_6654_();
                }
            }
        } else if (clickTypeIn == ClickType.SWAP && dragType >= 0 && dragType < 9) {
            Slot slot5 = (Slot)this.f_38839_.get(slotId);
            ItemStack itemstack9 = inventoryplayer.m_8020_(dragType);
            ItemStack itemstack12 = slot5.m_7993_();
            if (!itemstack9.m_41619_() || !itemstack12.m_41619_()) {
                if (itemstack9.m_41619_()) {
                    if (slot5.m_8010_(player)) {
                        inventoryplayer.m_6836_(dragType, itemstack12);
                        slot5.m_5852_(ItemStack.f_41583_);
                        slot5.m_142406_(player, itemstack12);
                    }
                } else if (itemstack12.m_41619_()) {
                    if (slot5.m_5857_(itemstack9)) {
                        int k1 = slot5.m_5866_(itemstack9);
                        if (itemstack9.m_41613_() > k1) {
                            slot5.m_5852_(itemstack9.m_41620_(k1));
                            if (slot5.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot5.getSlotIndex()].m_41619_()) {
                                this.filter[slot5.getSlotIndex()] = slot5.m_7993_().m_41777_();
                                this.filter[slot5.getSlotIndex()].m_41764_(1);
                                this.inv.filterChanged();
                            }
                        } else {
                            slot5.m_5852_(itemstack9);
                            if (slot5.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot5.getSlotIndex()].m_41619_()) {
                                this.filter[slot5.getSlotIndex()] = slot5.m_7993_().m_41777_();
                                this.filter[slot5.getSlotIndex()].m_41764_(1);
                                this.inv.filterChanged();
                            }
                            inventoryplayer.m_6836_(dragType, ItemStack.f_41583_);
                        }
                    }
                } else if (slot5.m_8010_(player) && slot5.m_5857_(itemstack9)) {
                    int l1 = slot5.m_5866_(itemstack9);
                    if (itemstack9.m_41613_() > l1) {
                        slot5.m_5852_(itemstack9.m_41620_(l1));
                        slot5.m_142406_(player, itemstack12);
                        if (slot5.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot5.getSlotIndex()].m_41619_()) {
                            this.filter[slot5.getSlotIndex()] = slot5.m_7993_().m_41777_();
                            this.filter[slot5.getSlotIndex()].m_41764_(1);
                            this.inv.filterChanged();
                        }
                        if (!inventoryplayer.m_36054_(itemstack12)) {
                            player.m_36176_(itemstack12, true);
                        }
                    } else {
                        slot5.m_5852_(itemstack9);
                        if (slot5.f_40218_ instanceof SlottedChestTileEntity.SlottedInv && this.filter[slot5.getSlotIndex()].m_41619_()) {
                            this.filter[slot5.getSlotIndex()] = slot5.m_7993_().m_41777_();
                            this.filter[slot5.getSlotIndex()].m_41764_(1);
                            this.inv.filterChanged();
                        }
                        inventoryplayer.m_6836_(dragType, itemstack12);
                        slot5.m_142406_(player, itemstack12);
                    }
                }
            }
        } else if (clickTypeIn == ClickType.CLONE && player.m_7500_() && this.m_142621_().m_41619_() && slotId >= 0) {
            Slot slot4 = (Slot)this.f_38839_.get(slotId);
            if (slot4 != null && slot4.m_6657_()) {
                ItemStack itemstack8 = slot4.m_7993_().m_41777_();
                itemstack8.m_41764_(itemstack8.m_41741_());
                this.m_142503_(itemstack8);
            }
        } else if (clickTypeIn == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
            Slot slot3 = (Slot)this.f_38839_.get(slotId);
            if (slot3 != null && slot3.m_6657_() && slot3.m_8010_(player)) {
                ItemStack itemstack7 = slot3.m_6201_(dragType == 0 ? 1 : slot3.m_7993_().m_41613_());
                slot3.m_142406_(player, itemstack7);
                player.m_36176_(itemstack7, true);
            }
        } else if (clickTypeIn == ClickType.PICKUP_ALL && slotId >= 0) {
            Slot slot2 = (Slot)this.f_38839_.get(slotId);
            ItemStack itemstack6 = this.m_142621_();
            if (!(itemstack6.m_41619_() || slot2 != null && slot2.m_6657_() && slot2.m_8010_(player))) {
                int i1 = dragType == 0 ? 0 : this.f_38839_.size() - 1;
                int j1 = dragType == 0 ? 1 : -1;
                for (int i3 = 0; i3 < 2; ++i3) {
                    for (int j3 = i1; j3 >= 0 && j3 < this.f_38839_.size() && itemstack6.m_41613_() < itemstack6.m_41741_(); j3 += j1) {
                        Slot slot8 = (Slot)this.f_38839_.get(j3);
                        if (!slot8.m_6657_() || !this.canAddItemToSlotLocked(slot8, itemstack6, true) || !slot8.m_8010_(player) || !this.m_5882_(itemstack6, slot8)) continue;
                        ItemStack itemstack14 = slot8.m_7993_();
                        if (i3 == 0 && itemstack14.m_41613_() == itemstack14.m_41741_()) continue;
                        int k3 = Math.min(itemstack6.m_41741_() - itemstack6.m_41613_(), itemstack14.m_41613_());
                        ItemStack itemstack4 = slot8.m_6201_(k3);
                        itemstack6.m_41769_(k3);
                        if (itemstack4.m_41619_()) {
                            slot8.m_5852_(ItemStack.f_41583_);
                        }
                        slot8.m_142406_(player, itemstack4);
                    }
                }
            }
            this.m_38946_();
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        try {
            this.doClick(slotId, dragType, clickTypeIn, player);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Container click");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Click info");
            crashreportcategory.m_128165_("Menu Type", () -> this.m_6772_() != null ? Registry.f_122863_.m_7981_((Object)this.m_6772_()).toString() : "<no type>");
            crashreportcategory.m_128165_("Menu Class", () -> ((Object)((Object)this)).getClass().getCanonicalName());
            crashreportcategory.m_128159_("Slot Count", (Object)this.f_38839_.size());
            crashreportcategory.m_128159_("Slot", (Object)slotId);
            crashreportcategory.m_128159_("Button", (Object)dragType);
            crashreportcategory.m_128159_("Type", (Object)dragType);
            throw new ReportedException(crashreport);
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack outStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && !slot.m_7993_().m_41619_()) {
            ItemStack stackInSlot = slot.m_7993_();
            outStack = stackInSlot.m_41777_();
            if (index < 54 ? !this.m_38903_(stackInSlot, 54, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            slot.m_6654_();
        }
        return outStack;
    }

    protected boolean m_38903_(ItemStack toMerge, int startIndex, int endIndex, boolean chestToPlayer) {
        ItemStack currentSlotStack;
        Slot slot;
        boolean flag = false;
        int i = startIndex;
        if (chestToPlayer) {
            i = endIndex - 1;
        }
        if (toMerge.m_41753_()) {
            while (!toMerge.m_41619_() && (!chestToPlayer && i < endIndex || chestToPlayer && i >= startIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                currentSlotStack = slot.m_7993_();
                if ((!currentSlotStack.m_41619_() || !chestToPlayer && !this.filter[i].m_41619_()) && (SlottedChestContainer.doStackContentsMatch(toMerge, currentSlotStack) || !chestToPlayer && SlottedChestContainer.doStackContentsMatch(this.filter[i], toMerge))) {
                    int totalCount = currentSlotStack.m_41613_() + toMerge.m_41613_();
                    if (currentSlotStack.m_41619_()) {
                        slot.m_5852_(this.filter[i].m_41777_());
                        currentSlotStack = slot.m_7993_();
                        currentSlotStack.m_41764_(0);
                    }
                    if (totalCount <= toMerge.m_41741_()) {
                        toMerge.m_41764_(0);
                        currentSlotStack.m_41764_(totalCount);
                        slot.m_6654_();
                        flag = true;
                    } else if (currentSlotStack.m_41613_() < toMerge.m_41741_()) {
                        toMerge.m_41774_(toMerge.m_41741_() - currentSlotStack.m_41613_());
                        currentSlotStack.m_41764_(toMerge.m_41741_());
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (chestToPlayer) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!toMerge.m_41619_() && chestToPlayer) {
            for (i = endIndex - 1; i >= startIndex; --i) {
                slot = (Slot)this.f_38839_.get(i);
                currentSlotStack = slot.m_7993_();
                if (!currentSlotStack.m_41619_() || !slot.m_5857_(toMerge)) continue;
                slot.m_5852_(toMerge.m_41777_());
                slot.m_6654_();
                toMerge.m_41764_(0);
                flag = true;
                break;
            }
        }
        return flag;
    }

    private boolean canAddItemToSlotLocked(@Nullable Slot slotIn, ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        if (slotIn != null && slotIn.f_40218_ instanceof SlottedChestTileEntity.SlottedInv) {
            return (this.filter[slotIn.getSlotIndex()].m_41619_() || SlottedChestContainer.doStackContentsMatch(this.filter[slotIn.getSlotIndex()], stack)) && slotIn.m_7993_().m_41613_() + (stackSizeMatters ? 0 : stack.m_41613_()) <= stack.m_41741_();
        }
        boolean bl = flag = slotIn == null || !slotIn.m_6657_();
        return !flag && stack.m_41656_(slotIn.m_7993_()) && ItemStack.m_41658_((ItemStack)slotIn.m_7993_(), (ItemStack)stack) ? slotIn.m_7993_().m_41613_() + (stackSizeMatters ? 0 : stack.m_41613_()) <= stack.m_41741_() : flag;
    }

    public static boolean doStackContentsMatch(ItemStack stackA, ItemStack stackB) {
        return stackB.m_41720_() == stackA.m_41720_() && ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB);
    }
}

