/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class AbstractShifterTileEntity
extends BlockEntity
implements ITickableTileEntity,
MenuProvider {
    private Direction facing = null;
    protected BlockPos endPos = null;

    protected <T extends AbstractShifterTileEntity> AbstractShifterTileEntity(BlockEntityType<T> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.m_58900_();
            if (!state.m_61138_((Property)ESProperties.FACING)) {
                return Direction.DOWN;
            }
            this.facing = (Direction)state.m_61143_((Property)ESProperties.FACING);
        }
        return this.facing;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.facing = null;
        this.refreshCache();
    }

    public void refreshCache() {
        BlockState target;
        int extension;
        Direction dir = this.getFacing();
        int maxChutes = (Integer)ESConfig.itemChuteRange.get();
        for (extension = 1; extension <= maxChutes && (target = this.f_58857_.m_8055_(this.f_58858_.m_5484_(dir, extension))).m_60734_() == ESBlocks.itemChute && target.m_61143_(ESProperties.AXIS) == dir.m_122434_(); ++extension) {
        }
        this.endPos = this.f_58858_.m_5484_(dir, extension);
    }

    public static ItemStack ejectItem(Level world, BlockPos outputPos, Direction fromSide, ItemStack stack, @Nullable LazyOptional<IItemHandler> outputHandlerCache) {
        BlockState outputState;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler handler = null;
        if (outputHandlerCache == null) {
            LazyOptional outputCap;
            BlockEntity outputTE = world.m_7702_(outputPos);
            if (outputTE != null && (outputCap = outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromSide.m_122424_())).isPresent()) {
                handler = (IItemHandler)outputCap.orElseThrow(NullPointerException::new);
            }
        } else if (outputHandlerCache.isPresent()) {
            handler = (IItemHandler)outputHandlerCache.orElseThrow(NullPointerException::new);
        }
        if (handler == null && (outputState = world.m_8055_(outputPos)).m_60734_() instanceof WorldlyContainerHolder) {
            WorldlyContainer inv = ((WorldlyContainerHolder)outputState.m_60734_()).m_5840_(outputState, (LevelAccessor)world, outputPos);
            handler = new InvWrapper((Container)inv);
        }
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack outStack = handler.insertItem(i, stack, false);
                if (outStack.m_41613_() == stack.m_41613_()) continue;
                return outStack;
            }
            return stack;
        }
        ItemEntity ent = new ItemEntity(world, (double)outputPos.m_123341_() + 0.5, (double)outputPos.m_123342_() + 0.5, (double)outputPos.m_123343_() + 0.5, stack);
        ent.m_20256_(Vec3.f_82478_);
        world.m_7967_((Entity)ent);
        return ItemStack.f_41583_;
    }

    public static FluidStack ejectFluid(Level world, BlockPos pos, Direction fromSide, FluidStack stack) {
        LazyOptional outHandlerCon;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        BlockEntity outputTE = world.m_7702_(pos);
        if (outputTE != null && (outHandlerCon = outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fromSide.m_122424_())).isPresent()) {
            IFluidHandler outHandler = (IFluidHandler)outHandlerCon.orElseThrow(NullPointerException::new);
            int filled = outHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            FluidStack out = stack.copy();
            out.shrink(filled);
            return out;
        }
        return stack;
    }
}

