/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractSplitterTE
extends BlockEntity
implements ITickableTileEntity {
    protected int mode = 6;
    protected final BlockPos[] endPos = new BlockPos[2];

    protected AbstractSplitterTE(BlockEntityType<? extends AbstractSplitterTE> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SplitDistribution getDistribution() {
        return SplitDistribution.TWELVE;
    }

    protected Direction getFacing() {
        BlockState state = this.m_58900_();
        if (!state.m_61138_((Property)ESProperties.FACING)) {
            return Direction.DOWN;
        }
        return (Direction)state.m_61143_((Property)ESProperties.FACING);
    }

    public int getMode() {
        return this.mode;
    }

    public int increaseMode() {
        ++this.mode;
        this.mode %= this.getDistribution().maxMode();
        this.m_6596_();
        return this.mode;
    }

    public void refreshCache() {
        Direction dir = this.getFacing();
        int maxChutes = (Integer)ESConfig.itemChuteRange.get();
        for (int i = 0; i < 2; ++i) {
            BlockState target;
            int extension;
            for (extension = 1; extension <= maxChutes && (target = this.f_58857_.m_8055_(this.f_58858_.m_5484_(dir, extension))).m_60734_() == ESBlocks.itemChute && target.m_61143_(ESProperties.AXIS) == dir.m_122434_(); ++extension) {
            }
            this.endPos[i] = this.f_58858_.m_5484_(dir, extension);
            dir = dir.m_122424_();
        }
    }

    public static enum SplitDistribution {
        TWELVE(12, new int[]{0, 1, 65, 273, 585, 2633, 1365, 3413, 2925, 1911, 3959, 2047, 4095}),
        FIFTEEN(15, new int[]{0, 1, 129, 1057, 2185, 4681, 5285, 10922, 21845, 22197, 23405, 15291, 15855, 16255, 16383, Short.MAX_VALUE});

        public final int base;
        private final int[] patterns;

        private SplitDistribution(int base, int[] patterns) {
            this.base = base;
            this.patterns = patterns;
        }

        public int maxMode() {
            return this.patterns.length;
        }

        public boolean shouldDispense(int mode, int stage) {
            return (this.patterns[mode % this.patterns.length] >>> (stage %= this.base) & 1) == 1;
        }
    }
}

