/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.AutoCrafterContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class AutoCrafterTileEntity
extends BlockEntity
implements INBTReceiver,
MenuProvider {
    @ObjectHolder(value="auto_crafter")
    public static BlockEntityType<AutoCrafterTileEntity> TYPE = null;
    protected final ItemStack[] inv = new ItemStack[this.invSize()];
    protected final CrafterInventory iInv = new CrafterInventory(this.inv, this);
    protected boolean redstone = false;
    @Nullable
    protected RecipeManager recipeManager = null;
    @Nullable
    public ResourceLocation recipe;
    private final LazyOptional<IItemHandler> hanOptional = LazyOptional.of(() -> new InventoryHandler());

    public AutoCrafterTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    protected AutoCrafterTileEntity(BlockEntityType<? extends AutoCrafterTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Arrays.fill(this.inv, ItemStack.f_41583_);
    }

    protected int invSize() {
        return 19;
    }

    public RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            this.recipeManager = this.f_58857_.f_46443_ ? Minecraft.m_91087_().m_91403_().m_105141_() : this.f_58857_.m_142572_().m_129894_();
        }
        return this.recipeManager;
    }

    @Nullable
    public static Recipe<?> lookupRecipe(RecipeManager manager, ResourceLocation recipe) {
        return recipe == null ? null : (Recipe)manager.m_44043_(recipe).orElse(null);
    }

    public static CraftingContainer prepareCraftingInv(ItemStack[] inv) {
        CraftingContainer craftInv = new CraftingContainer(new AbstractContainerMenu(null, 0){

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftInv.m_6836_(i, inv[i + 10]);
        }
        return craftInv;
    }

    @Nullable
    public Recipe<CraftingContainer> findRecipe(CraftingContainer fakeInv, @Nullable AutoCrafterContainer container) {
        Recipe<CraftingContainer> iRecipe;
        if (this.recipe == null) {
            Optional recipeOptional = this.getRecipeManager().m_44015_(RecipeType.f_44107_, (Container)fakeInv, this.f_58857_);
            iRecipe = this.validateRecipe(recipeOptional.orElse(null), container);
        } else {
            iRecipe = this.validateRecipe(AutoCrafterTileEntity.lookupRecipe(this.getRecipeManager(), this.recipe), container);
        }
        return iRecipe;
    }

    @Nullable
    public Recipe<CraftingContainer> validateRecipe(Recipe<?> rec, @Nullable AutoCrafterContainer container) {
        if (rec == null || rec.m_6671_() != RecipeType.f_44107_ || !rec.m_8004_(3, 3)) {
            return null;
        }
        return rec;
    }

    public void redstoneUpdate(boolean newReds) {
        if (newReds != this.redstone) {
            CraftingContainer fakeInv;
            Recipe<CraftingContainer> iRecipe;
            this.redstone = newReds;
            this.m_6596_();
            if (this.redstone && this.f_58857_ != null && !this.f_58857_.f_46443_ && (iRecipe = this.findRecipe(fakeInv = AutoCrafterTileEntity.prepareCraftingInv(this.inv), null)) != null) {
                ItemStack output = this.recipe != null ? iRecipe.m_8043_() : iRecipe.m_5874_((Container)fakeInv);
                if (this.inv[9].m_41619_() || BlockUtil.sameItem(this.inv[9], output) && output.m_41613_() + this.inv[9].m_41613_() <= this.inv[9].m_41741_()) {
                    Object ingredients;
                    if (this.recipe == null) {
                        ingredients = new ArrayList(9);
                        for (int i = 10; i < 19; ++i) {
                            if (this.inv[i].m_41619_()) continue;
                            ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.inv[i]}));
                        }
                    } else {
                        ingredients = iRecipe.m_7527_();
                    }
                    int[] used = new int[9];
                    Iterator iterator = ingredients.iterator();
                    block1: while (iterator.hasNext()) {
                        Ingredient ingr = (Ingredient)iterator.next();
                        if (ingr.m_43947_()) continue;
                        for (int i = 8; i >= 0; --i) {
                            if (this.inv[i].m_41613_() - used[i] <= 0 || !ingr.test(this.inv[i])) continue;
                            int n = i;
                            used[n] = used[n] + 1;
                            continue block1;
                        }
                        return;
                    }
                    ArrayList<ItemStack> containers = new ArrayList<ItemStack>(0);
                    for (int i = 0; i < 9; ++i) {
                        if (used[i] != 0 && this.inv[i].hasContainerItem()) {
                            ItemStack cont = this.inv[i].getContainerItem().m_41777_();
                            cont.m_41764_(used[i]);
                            containers.add(cont);
                        }
                        this.inv[i].m_41774_(used[i]);
                    }
                    if (this.inv[9].m_41619_()) {
                        this.inv[9] = output.m_41777_();
                    } else {
                        this.inv[9].m_41769_(output.m_41613_());
                    }
                    for (ItemStack s : containers) {
                        int slot = -1;
                        for (int i = 0; i < 9; ++i) {
                            if (BlockUtil.sameItem(s, this.inv[i])) {
                                slot = i;
                                break;
                            }
                            if (!this.inv[i].m_41619_()) continue;
                            slot = i;
                            break;
                        }
                        if (slot == -1) {
                            Containers.m_18992_((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + Math.random()), (double)((double)this.f_58858_.m_123342_() + Math.random()), (double)((double)this.f_58858_.m_123343_() + Math.random()), (ItemStack)s);
                            continue;
                        }
                        if (this.inv[slot].m_41619_()) {
                            this.inv[slot] = s;
                            continue;
                        }
                        this.inv[slot].m_41769_(s.m_41613_());
                    }
                }
            }
        }
    }

    public void dropItems() {
        for (int i = 0; i < 10; ++i) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.inv[i]);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        String recPath = nbt.m_128461_("recipe");
        this.recipe = recPath.isEmpty() ? null : new ResourceLocation(recPath);
        for (int i = 0; i < this.inv.length; ++i) {
            if (!nbt.m_128441_("slot_" + i)) continue;
            this.inv[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("slot_" + i));
        }
        this.redstone = nbt.m_128471_("reds");
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i].m_41619_()) continue;
            nbt.m_128365_("slot_" + i, (Tag)this.inv[i].m_41739_(new CompoundTag()));
        }
        if (this.recipe != null) {
            nbt.m_128359_("recipe", this.recipe.toString());
        }
        nbt.m_128379_("reds", this.redstone);
        return nbt;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.recipe != null) {
            nbt.m_128359_("recipe", this.recipe.toString());
        }
        return nbt;
    }

    public int getLegalSlots(Item item, Container inv, @Nullable AutoCrafterContainer container) {
        int count;
        block3: {
            block2: {
                count = 0;
                if (this.recipe != null) break block2;
                for (int i = 10; i < 19; ++i) {
                    if (inv.m_8020_(i).m_41720_() != item) continue;
                    ++count;
                }
                break block3;
            }
            Recipe<CraftingContainer> rec = this.validateRecipe(AutoCrafterTileEntity.lookupRecipe(this.getRecipeManager(), this.recipe), container);
            if (rec == null) break block3;
            ItemStack testStack = new ItemStack((ItemLike)item, 1);
            for (Ingredient ingr : rec.m_7527_()) {
                if (!ingr.test(testStack)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getUsedSlots(Item item, Container inv) {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (inv.m_8020_(i).m_41720_() != item) continue;
            ++count;
        }
        return count;
    }

    public void m_7651_() {
        super.m_7651_();
        this.hanOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.hanOptional;
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        String str = nbt.m_128461_("recipe");
        this.recipe = !str.isEmpty() ? new ResourceLocation(str) : null;
        if (!this.f_58857_.f_46443_) {
            this.setRecipe(AutoCrafterTileEntity.lookupRecipe(this.getRecipeManager(), this.recipe));
        }
        this.m_6596_();
    }

    public void setRecipe(@Nullable Recipe<?> rec) {
        ResourceLocation resourceLocation = this.recipe = rec == null ? null : rec.m_6423_();
        if (this.recipe != null) {
            for (int i = 10; i < 19; ++i) {
                this.inv[i] = ItemStack.f_41583_;
                this.m_6596_();
            }
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("recipe", this.recipe == null ? "" : this.recipe.toString());
        BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendNBTToClient(nbt, this.f_58858_));
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.auto_crafter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new AutoCrafterContainer(id, playerInventory, this.iInv, this.f_58858_);
    }

    public static class CrafterInventory
    implements Container {
        private final ItemStack[] inv;
        @Nullable
        private final AutoCrafterTileEntity te;

        private CrafterInventory(ItemStack[] inv, @Nullable AutoCrafterTileEntity te) {
            this.inv = inv;
            this.te = te;
        }

        public int m_6643_() {
            return this.inv.length;
        }

        public ItemStack m_8020_(int index) {
            return index >= this.inv.length ? ItemStack.f_41583_ : this.inv[index];
        }

        public ItemStack m_7407_(int index, int count) {
            if (index >= this.inv.length || this.inv[index].m_41619_()) {
                return ItemStack.f_41583_;
            }
            return this.inv[index].m_41620_(count);
        }

        public ItemStack m_8016_(int index) {
            if (index >= this.inv.length) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = this.inv[index].m_41777_();
            this.inv[index].m_41764_(0);
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            if (index < this.inv.length) {
                this.inv[index] = stack;
            }
        }

        public int m_6893_() {
            return 64;
        }

        public void m_6596_() {
            if (this.te != null) {
                this.te.m_6596_();
            }
        }

        public boolean m_6542_(Player playerEntity) {
            return true;
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return index < this.inv.length - 1;
        }

        public void m_6211_() {
            Arrays.fill(this.inv, ItemStack.f_41583_);
        }

        public boolean m_7983_() {
            for (ItemStack itemStack : this.inv) {
                if (itemStack.m_41619_()) continue;
                return false;
            }
            return true;
        }
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 10;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 10 ? AutoCrafterTileEntity.this.inv[slot] : ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 9 || stack.m_41619_()) {
                return stack;
            }
            Item item = stack.m_41720_();
            if (AutoCrafterTileEntity.this.inv[slot].m_41619_() && AutoCrafterTileEntity.this.getLegalSlots(item, AutoCrafterTileEntity.this.iInv, null) <= AutoCrafterTileEntity.this.getUsedSlots(item, AutoCrafterTileEntity.this.iInv)) {
                return stack;
            }
            if (!BlockUtil.sameItem(stack, AutoCrafterTileEntity.this.inv[slot]) && !AutoCrafterTileEntity.this.inv[slot].m_41619_()) {
                return stack;
            }
            int change = Math.min(stack.m_41741_() - AutoCrafterTileEntity.this.inv[slot].m_41613_(), stack.m_41613_());
            if (!simulate) {
                if (AutoCrafterTileEntity.this.inv[slot].m_41619_()) {
                    AutoCrafterTileEntity.this.inv[slot] = stack.m_41777_();
                } else {
                    AutoCrafterTileEntity.this.inv[slot].m_41769_(change);
                }
            }
            ItemStack out = stack.m_41777_();
            out.m_41774_(change);
            return stack.m_41613_() == change ? ItemStack.f_41583_ : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            Item item;
            if (slot == 9 && !AutoCrafterTileEntity.this.inv[slot].m_41619_()) {
                int change = Math.min(AutoCrafterTileEntity.this.inv[9].m_41613_(), amount);
                ItemStack out = AutoCrafterTileEntity.this.inv[9].m_41777_();
                out.m_41764_(change);
                if (!simulate) {
                    AutoCrafterTileEntity.this.inv[9].m_41774_(change);
                }
                return change == 0 ? ItemStack.f_41583_ : out;
            }
            if (slot < 9 && slot >= 0 && !AutoCrafterTileEntity.this.inv[slot].m_41619_() && AutoCrafterTileEntity.this.getUsedSlots(item = AutoCrafterTileEntity.this.inv[slot].m_41720_(), AutoCrafterTileEntity.this.iInv) > AutoCrafterTileEntity.this.getLegalSlots(item, AutoCrafterTileEntity.this.iInv, null)) {
                int change = Math.min(AutoCrafterTileEntity.this.inv[slot].m_41613_(), amount);
                ItemStack out = AutoCrafterTileEntity.this.inv[slot].m_41777_();
                out.m_41764_(change);
                if (!simulate) {
                    AutoCrafterTileEntity.this.inv[slot].m_41774_(change);
                }
                return change == 0 ? ItemStack.f_41583_ : out;
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return slot < 10 ? 64 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < 9;
        }
    }
}

