/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.AbstractSplitterTE;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BasicFluidSplitterTileEntity
extends AbstractSplitterTE {
    @ObjectHolder(value="basic_fluid_splitter")
    public static BlockEntityType<BasicFluidSplitterTileEntity> TYPE = null;
    private final FluidStack[] inventory = new FluidStack[]{FluidStack.EMPTY, FluidStack.EMPTY};
    private static final int CAPACITY = 4000;
    private LazyOptional<IFluidHandler> primaryOpt = LazyOptional.of(() -> new OutFluidHandler(1));
    private LazyOptional<IFluidHandler> secondaryOpt = LazyOptional.of(() -> new OutFluidHandler(0));
    private LazyOptional<IFluidHandler> inOpt = LazyOptional.of(() -> new InHandler());
    private int transferred = 0;

    public BasicFluidSplitterTileEntity(BlockEntityType<? extends AbstractSplitterTE> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BasicFluidSplitterTileEntity(BlockPos pos, BlockState state) {
        this(TYPE, pos, state);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
        this.primaryOpt = LazyOptional.of(() -> new OutFluidHandler(1));
        this.secondaryOpt = LazyOptional.of(() -> new OutFluidHandler(0));
        this.inOpt = LazyOptional.of(() -> new InHandler());
        this.endPos[1] = null;
        this.endPos[0] = null;
    }

    @Override
    public void tick() {
        if (this.endPos[0] == null || this.endPos[1] == null) {
            this.refreshCache();
        }
        Direction dir = this.getFacing();
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = AbstractShifterTileEntity.ejectFluid(this.f_58857_, this.endPos[i], i == 0 ? dir : dir.m_122424_(), this.inventory[i]);
        }
        this.m_6596_();
    }

    public void m_7651_() {
        super.m_7651_();
        this.primaryOpt.invalidate();
        this.secondaryOpt.invalidate();
        this.inOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Direction dir = this.getFacing();
            return side == dir ? this.primaryOpt : (side == dir.m_122424_() ? this.secondaryOpt : this.inOpt);
        }
        return super.getCapability(cap, side);
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128344_("type", (byte)1);
        nbt.m_128405_("mode", this.mode);
        nbt.m_128405_("transferred", this.transferred);
        for (int i = 0; i < 2; ++i) {
            if (this.inventory[i].isEmpty()) continue;
            CompoundTag inner = new CompoundTag();
            this.inventory[i].writeToNBT(inner);
            nbt.m_128365_("inv_" + i, (Tag)inner);
        }
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mode = nbt.m_128445_("type") == 1 ? nbt.m_128451_("mode") : 3 + 3 * nbt.m_128451_("mode");
        this.transferred = nbt.m_128451_("transferred");
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("inv_" + i));
        }
    }

    private class InHandler
    implements IFluidHandler {
        private InHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            int goDown;
            int accepted;
            if (stack.isEmpty()) {
                return 0;
            }
            if (!BasicFluidSplitterTileEntity.this.inventory[0].isEmpty() && !BlockUtil.sameFluid(stack, BasicFluidSplitterTileEntity.this.inventory[0]) || !BasicFluidSplitterTileEntity.this.inventory[1].isEmpty() && !BlockUtil.sameFluid(stack, BasicFluidSplitterTileEntity.this.inventory[1])) {
                return 0;
            }
            int numerator = BasicFluidSplitterTileEntity.this.getMode();
            AbstractSplitterTE.SplitDistribution distribution = BasicFluidSplitterTileEntity.this.getDistribution();
            int denominator = distribution.base;
            int spaceDown = 4000 - BasicFluidSplitterTileEntity.this.inventory[0].getAmount();
            int spaceUp = 4000 - BasicFluidSplitterTileEntity.this.inventory[1].getAmount();
            if (numerator == 0) {
                accepted = Math.min(spaceUp, stack.getAmount());
                goDown = 0;
            } else if (numerator == denominator) {
                goDown = accepted = Math.min(spaceDown, stack.getAmount());
            } else {
                int baseQty = stack.getAmount() - stack.getAmount() % denominator;
                accepted = denominator * spaceDown / numerator;
                accepted = Math.min(accepted, denominator * spaceUp / (denominator - numerator));
                if ((accepted = Math.max(0, Math.min(baseQty, accepted))) % denominator != 0) {
                    accepted -= accepted % denominator;
                }
                goDown = numerator * accepted / denominator;
                spaceDown -= goDown;
                spaceUp -= accepted - goDown;
                int remainder = stack.getAmount() - accepted;
                for (int i = 0; i < remainder; ++i) {
                    boolean shouldGoDown = distribution.shouldDispense(BasicFluidSplitterTileEntity.this.mode, BasicFluidSplitterTileEntity.this.transferred + i);
                    if (shouldGoDown) {
                        if (spaceDown <= 0) break;
                        --spaceDown;
                        ++goDown;
                        ++accepted;
                        continue;
                    }
                    if (spaceUp <= 0) break;
                    --spaceUp;
                    ++accepted;
                }
            }
            int goUp = accepted - goDown;
            if (action.execute() && accepted != 0) {
                if (BasicFluidSplitterTileEntity.this.inventory[0].isEmpty()) {
                    BasicFluidSplitterTileEntity.this.inventory[0] = stack.copy();
                    BasicFluidSplitterTileEntity.this.inventory[0].setAmount(goDown);
                } else {
                    BasicFluidSplitterTileEntity.this.inventory[0].grow(goDown);
                }
                if (BasicFluidSplitterTileEntity.this.inventory[1].isEmpty()) {
                    BasicFluidSplitterTileEntity.this.inventory[1] = stack.copy();
                    BasicFluidSplitterTileEntity.this.inventory[1].setAmount(goUp);
                } else {
                    BasicFluidSplitterTileEntity.this.inventory[1].grow(goUp);
                }
                BasicFluidSplitterTileEntity.this.transferred += accepted;
                BasicFluidSplitterTileEntity.this.transferred %= denominator;
            }
            return accepted;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    protected class OutFluidHandler
    implements IFluidHandler {
        private final int index;

        private OutFluidHandler(int index) {
            this.index = index;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return BasicFluidSplitterTileEntity.this.inventory[this.index];
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int drained;
            if (BlockUtil.sameFluid(resource, BasicFluidSplitterTileEntity.this.inventory[this.index]) && (drained = Math.min(resource.getAmount(), BasicFluidSplitterTileEntity.this.inventory[this.index].getAmount())) > 0) {
                FluidStack out = BasicFluidSplitterTileEntity.this.inventory[this.index].copy();
                out.setAmount(drained);
                if (action.execute()) {
                    BasicFluidSplitterTileEntity.this.inventory[this.index].shrink(drained);
                    BasicFluidSplitterTileEntity.this.m_6596_();
                }
                return out;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int drained = Math.min(maxDrain, BasicFluidSplitterTileEntity.this.inventory[this.index].getAmount());
            if (drained > 0) {
                FluidStack out = BasicFluidSplitterTileEntity.this.inventory[this.index].copy();
                out.setAmount(drained);
                if (action.execute()) {
                    BasicFluidSplitterTileEntity.this.inventory[this.index].shrink(drained);
                    BasicFluidSplitterTileEntity.this.m_6596_();
                }
                return out;
            }
            return FluidStack.EMPTY;
        }
    }
}

