/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.FluidShifterContainer;
import com.Da_Technomancer.essentials.gui.container.FluidSlotManager;
import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class FluidShifterTileEntity
extends AbstractShifterTileEntity
implements IFluidSlotTE {
    @ObjectHolder(value="fluid_shifter")
    public static BlockEntityType<FluidShifterTileEntity> TYPE = null;
    private static final int CAPACITY = 4000;
    private FluidSlotManager fluidManager;
    private FluidStack fluid = FluidStack.EMPTY;
    private LazyOptional<IFluidHandler> invOptional = LazyOptional.of(() -> new FluidHandler());

    public FluidSlotManager getFluidManager() {
        if (this.fluidManager == null) {
            this.fluidManager = new FluidSlotManager(this.fluid, 4000);
        }
        return this.fluidManager;
    }

    public FluidShifterTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    public void serverTick() {
        FluidStack remaining;
        if (this.endPos == null) {
            this.refreshCache();
        }
        if ((remaining = AbstractShifterTileEntity.ejectFluid(this.f_58857_, this.endPos, this.getFacing(), this.fluid)).getAmount() != this.fluid.getAmount()) {
            this.fluid = remaining;
            this.getFluidManager().updateState(this.fluid);
            this.m_6596_();
        }
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128365_("fluid", (Tag)this.fluid.writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid"));
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(super.m_5995_());
    }

    public void m_7651_() {
        super.m_7651_();
        this.invOptional.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.invOptional;
        }
        return super.getCapability(cap, facing);
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.fluid_shifter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new FluidShifterContainer(id, playerInventory, this.f_58858_);
    }

    @Override
    public IFluidHandler getFluidHandler() {
        return (IFluidHandler)this.invOptional.orElseGet(() -> new FluidHandler());
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidShifterTileEntity.this.fluid;
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if ((FluidShifterTileEntity.this.fluid.isEmpty() || BlockUtil.sameFluid(FluidShifterTileEntity.this.fluid, resource)) && !resource.isEmpty()) {
                int filled = Math.min(4000 - FluidShifterTileEntity.this.fluid.getAmount(), resource.getAmount());
                if (filled > 0 && action.execute()) {
                    if (FluidShifterTileEntity.this.fluid.isEmpty()) {
                        FluidShifterTileEntity.this.fluid = resource.copy();
                        FluidShifterTileEntity.this.fluid.setAmount(filled);
                    } else {
                        FluidShifterTileEntity.this.fluid.grow(filled);
                    }
                    FluidShifterTileEntity.this.m_6596_();
                    FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                }
                return filled;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockUtil.sameFluid(FluidShifterTileEntity.this.fluid, resource)) {
                FluidStack drainFluid;
                int drained = Math.min(resource.getAmount(), FluidShifterTileEntity.this.fluid.getAmount());
                FluidStack fluidStack = drainFluid = drained == 0 ? FluidStack.EMPTY : FluidShifterTileEntity.this.fluid.copy();
                if (!drainFluid.isEmpty()) {
                    drainFluid.setAmount(drained);
                }
                if (drained > 0 && action.execute()) {
                    FluidShifterTileEntity.this.fluid.shrink(drained);
                    FluidShifterTileEntity.this.m_6596_();
                    FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                }
                return drainFluid;
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drainFluid;
            int drained = Math.min(maxDrain, FluidShifterTileEntity.this.fluid.getAmount());
            FluidStack fluidStack = drainFluid = drained == 0 ? FluidStack.EMPTY : FluidShifterTileEntity.this.fluid.copy();
            if (!drainFluid.isEmpty()) {
                drainFluid.setAmount(drained);
            }
            if (drained > 0 && action.execute()) {
                FluidShifterTileEntity.this.fluid.shrink(drained);
                FluidShifterTileEntity.this.getFluidManager().updateState(FluidShifterTileEntity.this.fluid);
                FluidShifterTileEntity.this.m_6596_();
            }
            return drainFluid;
        }
    }
}

