/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class HopperFilterTileEntity
extends BlockEntity
implements INBTReceiver {
    @ObjectHolder(value="hopper_filter")
    public static BlockEntityType<HopperFilterTileEntity> TYPE = null;
    private Direction.Axis axisCache = null;
    private ItemStack filter = ItemStack.f_41583_;
    private LazyOptional<IItemHandler> passedHandlerPos = null;
    private LazyOptional<IItemHandler> passedHandlerNeg = null;

    public HopperFilterTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendNBTToClient(filter.m_41739_(new CompoundTag()), this.f_58858_));
        this.m_6596_();
    }

    private Direction.Axis getAxis() {
        if (this.axisCache == null) {
            BlockState state = this.m_58900_();
            if (state.m_60734_() == ESBlocks.hopperFilter) {
                this.axisCache = (Direction.Axis)state.m_61143_(ESProperties.AXIS);
            } else {
                return Direction.Axis.Y;
            }
        }
        return this.axisCache;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.axisCache = null;
        if (this.passedHandlerNeg != null) {
            this.passedHandlerNeg.invalidate();
            this.passedHandlerPos.invalidate();
        }
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128365_("filter", (Tag)this.filter.m_41739_(new CompoundTag()));
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.filter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("filter"));
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(super.m_5995_());
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        this.filter = ItemStack.m_41712_((CompoundTag)nbt);
    }

    public static boolean matchFilter(ItemStack query, ItemStack filt) {
        CompoundTag nbt;
        if (filt.m_41619_()) {
            return false;
        }
        if (filt.m_41720_() instanceof BlockItem && ((BlockItem)filt.m_41720_()).m_40614_() instanceof ShulkerBoxBlock && (nbt = filt.m_41783_()) != null) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("BlockEntityTag"), (NonNullList)nonnulllist);
            for (ItemStack singleFilt : nonnulllist) {
                if (!HopperFilterTileEntity.matchFilter(query, singleFilt)) continue;
                return true;
            }
            return false;
        }
        return query.m_41720_() == filt.m_41720_();
    }

    private void updatePassedOptionals() {
        if (this.passedHandlerPos == null || !this.passedHandlerPos.isPresent() && this.passedHandlerNeg == null || !this.passedHandlerNeg.isPresent()) {
            this.passedHandlerNeg = LazyOptional.of(() -> new ProxyItemHandler(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)this.getAxis())));
            this.passedHandlerPos = LazyOptional.of(() -> new ProxyItemHandler(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getAxis())));
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.passedHandlerNeg != null) {
            this.passedHandlerNeg.invalidate();
            this.passedHandlerPos.invalidate();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side.m_122434_() == this.getAxis()) {
            this.updatePassedOptionals();
            return side.m_122421_() == Direction.AxisDirection.POSITIVE ? this.passedHandlerPos : this.passedHandlerNeg;
        }
        return super.getCapability(cap, side);
    }

    private class ProxyItemHandler
    implements IItemHandler {
        private final Direction side;
        private LazyOptional<IItemHandler> src = LazyOptional.empty();

        private ProxyItemHandler(Direction side) {
            this.side = side;
        }

        @Nullable
        private IItemHandler getHandler() {
            BlockState checkState;
            if (this.src.isPresent()) {
                return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
            }
            BlockPos checkPos = HopperFilterTileEntity.this.f_58858_.m_142300_(this.side.m_122424_());
            BlockEntity checkTE = HopperFilterTileEntity.this.f_58857_.m_7702_(checkPos);
            if (checkTE != null) {
                this.src = checkTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side);
                if (this.src.isPresent()) {
                    return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
                }
            }
            if ((checkState = HopperFilterTileEntity.this.f_58857_.m_8055_(checkPos)).m_60734_() instanceof WorldlyContainerHolder) {
                WorldlyContainer inv = ((WorldlyContainerHolder)checkState.m_60734_()).m_5840_(checkState, (LevelAccessor)HopperFilterTileEntity.this.f_58857_, checkPos);
                return new InvWrapper((Container)inv);
            }
            return null;
        }

        public int getSlots() {
            IItemHandler handler = this.getHandler();
            return handler == null ? 0 : handler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            IItemHandler handler = this.getHandler();
            return handler == null ? ItemStack.f_41583_ : handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            IItemHandler handler = this.getHandler();
            if (handler != null && HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter)) {
                return handler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            IItemHandler handler = this.getHandler();
            if (handler != null && HopperFilterTileEntity.matchFilter(this.getStackInSlot(slot), HopperFilterTileEntity.this.filter)) {
                return handler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            IItemHandler handler = this.getHandler();
            return handler == null ? 0 : handler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            IItemHandler handler = this.getHandler();
            return handler != null && HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter) && handler.isItemValid(slot, stack);
        }
    }
}

