/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class LinkHelper {
    public static final Tag<Item> LINKING_TOOLS = ItemTags.m_13194_((String)new ResourceLocation("essentials", "linking_tool").toString());
    public static final String POS_NBT = "c_link";
    public static final String DIM_NBT = "c_link_dim";
    public static final byte LINK_PACKET_ID = 8;
    @Deprecated
    public static final byte CLEAR_PACKET_ID = 9;
    public static final byte REMOVE_PACKET_ID = 10;
    private final Set<BlockPos> linked = new HashSet<BlockPos>();
    private final ILinkTE te;

    public LinkHelper(ILinkTE te) {
        this.te = te;
    }

    public Set<BlockPos> getLinksRelative() {
        return this.linked;
    }

    public Iterable<BlockPos> getLinksAbsolute() {
        BlockPos selfPos = this.te.getTE().m_58899_();
        return this.linked.stream().map(relPos -> relPos.m_141952_((Vec3i)selfPos)).collect(Collectors.toList());
    }

    public void readNBT(CompoundTag nbt) {
        int i = 0;
        while (nbt.m_128441_("link_" + i)) {
            this.linked.add(BlockPos.m_122022_((long)nbt.m_128454_("link_" + i)));
            ++i;
        }
    }

    public void writeNBT(CompoundTag nbt) {
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.m_128356_("link_" + count++, relPos.m_121878_());
        }
    }

    public boolean addLink(ILinkTE endpoint, @Nullable Player player) {
        if (this.linked.size() >= this.te.getMaxLinks()) {
            return false;
        }
        BlockPos tePos = this.te.getTE().m_58899_();
        BlockPos linkPos = endpoint.getTE().m_58899_().m_141950_((Vec3i)tePos);
        this.linked.add(linkPos);
        BlockUtil.sendClientPacketAround(this.te.getTE().m_58904_(), tePos, new SendLongToClient(8, linkPos.m_121878_(), tePos));
        this.te.getTE().m_6596_();
        return true;
    }

    public void removeLink(BlockPos endpoint) {
        BlockPos tePos = this.te.getTE().m_58899_();
        this.linked.remove(endpoint);
        BlockUtil.sendClientPacketAround(this.te.getTE().m_58904_(), tePos, new SendLongToClient(10, endpoint.m_121878_(), tePos));
        this.te.getTE().m_6596_();
    }

    public void unlinkAllEndpoints() {
        BlockPos selfPos = this.te.getTE().m_58899_();
        Level world = this.te.getTE().m_58904_();
        for (BlockPos relPos : this.linked) {
            BlockPos endPos = relPos.m_141952_((Vec3i)selfPos);
            BlockEntity endTe = world.m_7702_(endPos);
            if (!(endTe instanceof ILinkTE)) continue;
            ((ILinkTE)endTe).removeLinkEnd(selfPos);
        }
    }

    public boolean handleIncomingPacket(byte discriminator, long message) {
        if (discriminator == 8) {
            this.linked.add(BlockPos.m_122022_((long)message));
            return true;
        }
        if (discriminator == 10) {
            this.linked.remove(BlockPos.m_122022_((long)message));
            return true;
        }
        return false;
    }

    public AABB frustrum() {
        BlockPos pos = this.te.getTE().m_58899_();
        int[] min = new int[3];
        int[] max = new int[3];
        for (BlockPos link : this.te.getLinks()) {
            min[0] = Math.min(min[0], link.m_123341_());
            min[1] = Math.min(min[1], link.m_123342_());
            min[2] = Math.min(min[2], link.m_123343_());
            max[0] = Math.max(max[0], link.m_123341_());
            max[1] = Math.max(max[1], link.m_123342_());
            max[2] = Math.max(max[2], link.m_123343_());
        }
        return new AABB((double)(min[0] + pos.m_123341_()), (double)(min[1] + pos.m_123342_()), (double)(min[2] + pos.m_123343_()), (double)(max[0] + pos.m_123341_() + 1), (double)(max[1] + pos.m_123342_() + 1), (double)(max[2] + pos.m_123343_() + 1));
    }

    public static boolean isLinkTool(ItemStack stack) {
        return LINKING_TOOLS.m_8110_((Object)stack.m_41720_());
    }

    public static ItemStack wrench(ILinkTE linkTE, ItemStack wrench, Player player) {
        if (player.m_6047_()) {
            player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.clear"), player.m_142081_());
            ArrayList<BlockPos> links = new ArrayList<BlockPos>(linkTE.getLinks());
            Level world = linkTE.getTE().m_58904_();
            BlockPos srcPos = linkTE.getTE().m_58899_();
            for (BlockPos link : links) {
                linkTE.removeLinkSource(link);
                BlockEntity endTE = world.m_7702_(srcPos.m_141952_((Vec3i)link));
                if (!(endTE instanceof ILinkTE)) continue;
                ((ILinkTE)endTE).removeLinkEnd(srcPos);
            }
            LinkHelper.clearLinkNBT(wrench);
            return wrench;
        }
        Pair<String, BlockPos> wrenchData = LinkHelper.readLinkNBT(wrench);
        if (wrenchData != null && ((String)wrenchData.getLeft()).equals(LinkHelper.getWorldString(player.f_19853_))) {
            BlockEntity prevTE = player.f_19853_.m_7702_((BlockPos)wrenchData.getRight());
            if (prevTE instanceof ILinkTE && ((ILinkTE)prevTE).canLink(linkTE) && prevTE != linkTE) {
                int range = ((ILinkTE)prevTE).getRange();
                if (((BlockPos)wrenchData.getRight()).m_123331_((Vec3i)linkTE.getTE().m_58899_()) <= (double)(range * range)) {
                    ILinkTE prevLinkTe = (ILinkTE)prevTE;
                    BlockPos relLinkPos = linkTE.getTE().m_58899_().m_141950_((Vec3i)prevTE.m_58899_());
                    if (prevLinkTe.getLinks().contains(relLinkPos)) {
                        prevLinkTe.removeLinkSource(relLinkPos);
                        linkTE.removeLinkEnd(prevTE.m_58899_());
                        player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.remove", new Object[]{prevTE.m_58899_(), linkTE.getTE().m_58899_()}), player.m_142081_());
                    } else if (prevLinkTe.getLinks().size() < prevLinkTe.getMaxLinks()) {
                        if (prevLinkTe.createLinkSource(linkTE, player)) {
                            linkTE.createLinkEnd(prevLinkTe);
                            player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.success", new Object[]{prevTE.m_58899_(), linkTE.getTE().m_58899_()}), player.m_142081_());
                        }
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.full", new Object[]{prevLinkTe.getMaxLinks()}), player.m_142081_());
                    }
                } else {
                    player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.range"), player.m_142081_());
                }
                LinkHelper.clearLinkNBT(wrench);
                return wrench;
            }
            player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.invalid"), player.m_142081_());
        } else if (linkTE.canBeginLinking()) {
            LinkHelper.setLinkNBT(wrench, linkTE.getTE().m_58899_(), LinkHelper.getWorldString(linkTE.getTE().m_58904_()));
            player.m_6352_((Component)new TranslatableComponent("tt.essentials.linking.start"), player.m_142081_());
            return wrench;
        }
        LinkHelper.clearLinkNBT(wrench);
        return wrench;
    }

    private static String getWorldString(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    private static void setLinkNBT(ItemStack linkingTool, BlockPos targetPos, String targetWorld) {
        CompoundTag itemNBT = linkingTool.m_41784_();
        itemNBT.m_128356_(POS_NBT, targetPos.m_121878_());
        itemNBT.m_128359_(DIM_NBT, targetWorld);
    }

    private static void clearLinkNBT(ItemStack linkingTool) {
        CompoundTag itemNBT = linkingTool.m_41783_();
        if (itemNBT != null) {
            itemNBT.m_128473_(POS_NBT);
            itemNBT.m_128473_(DIM_NBT);
        }
    }

    @Nullable
    private static Pair<String, BlockPos> readLinkNBT(ItemStack linkingTool) {
        CompoundTag itemNBT = linkingTool.m_41783_();
        if (itemNBT == null) {
            return null;
        }
        if (itemNBT.m_128441_(POS_NBT) && itemNBT.m_128441_(DIM_NBT)) {
            return Pair.of((Object)itemNBT.m_128461_(DIM_NBT), (Object)BlockPos.m_122022_((long)itemNBT.m_128454_(POS_NBT)));
        }
        return null;
    }
}

