/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.gui.container.SlottedChestContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendNBTToClient;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class SlottedChestTileEntity
extends BlockEntity
implements INBTReceiver,
MenuProvider {
    @ObjectHolder(value="slotted_chest")
    public static BlockEntityType<SlottedChestTileEntity> TYPE = null;
    private ItemStack[] inv = new ItemStack[54];
    public ItemStack[] lockedInv = new ItemStack[54];
    public final SlottedInv iInv = new SlottedInv(this.inv, this.lockedInv, this);

    public SlottedChestTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        for (int i = 0; i < 54; ++i) {
            this.inv[i] = ItemStack.f_41583_;
            this.lockedInv[i] = ItemStack.f_41583_;
        }
    }

    public float calcComparator() {
        float f = 0.0f;
        for (ItemStack itemstack : this.inv) {
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(64, itemstack.m_41741_());
        }
        return f /= (float)this.inv.length;
    }

    private void filterChanged() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        CompoundTag slotNBT = new CompoundTag();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].m_41619_()) continue;
            slotNBT.m_128365_("lock" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
        BlockUtil.sendClientPacketAround(this.f_58857_, this.f_58858_, new SendNBTToClient(slotNBT, this.f_58858_));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < 54; ++i) {
            if (nbt.m_128441_("slot" + i)) {
                this.inv[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("slot" + i));
                this.lockedInv[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("slot" + i));
            }
            if (!nbt.m_128441_("lockSlot" + i)) continue;
            this.lockedInv[i] = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lockSlot" + i));
        }
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        for (int i = 0; i < 54; ++i) {
            if (!this.inv[i].m_41619_()) {
                nbt.m_128365_("slot" + i, (Tag)this.inv[i].m_41739_(new CompoundTag()));
            }
            if (this.lockedInv[i].m_41619_()) continue;
            nbt.m_128365_("lockSlot" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
        return nbt;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        for (int i = 0; i < 54; ++i) {
            if (this.lockedInv[i].m_41619_()) continue;
            nbt.m_128365_("lockSlot" + i, (Tag)this.lockedInv[i].m_41739_(new CompoundTag()));
        }
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new InventoryHandler());
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        for (int i = 0; i < 54; ++i) {
            this.lockedInv[i] = nbt.m_128441_("lock" + i) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lock" + i)) : ItemStack.f_41583_;
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.slotted_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new SlottedChestContainer(id, playerInventory, this.iInv, this.lockedInv);
    }

    public static class SlottedInv
    implements Container {
        private final ItemStack[] inv;
        private final ItemStack[] lockedInv;
        @Nullable
        private final SlottedChestTileEntity te;

        public SlottedInv(ItemStack[] inv, ItemStack[] filter, @Nullable SlottedChestTileEntity te) {
            this.inv = inv;
            this.lockedInv = filter;
            this.te = te;
            for (int i = 0; i < inv.length; ++i) {
                if (inv[i] != null) continue;
                inv[i] = ItemStack.f_41583_;
            }
        }

        public int m_6643_() {
            return this.inv.length;
        }

        public ItemStack m_8020_(int index) {
            return index >= this.inv.length ? ItemStack.f_41583_ : this.inv[index];
        }

        public ItemStack m_7407_(int index, int count) {
            if (index >= this.inv.length || this.inv[index].m_41619_()) {
                return ItemStack.f_41583_;
            }
            return this.inv[index].m_41620_(count);
        }

        public ItemStack m_8016_(int index) {
            if (index >= this.inv.length) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = this.inv[index].m_41777_();
            this.inv[index].m_41764_(0);
            return stack;
        }

        public void m_6836_(int index, ItemStack stack) {
            if (index < this.inv.length) {
                this.inv[index] = stack;
                if (!stack.m_41619_()) {
                    this.lockedInv[index] = stack.m_41777_();
                    this.lockedInv[index].m_41764_(1);
                }
            }
        }

        public int m_6893_() {
            return 64;
        }

        public void m_6596_() {
            if (this.te != null) {
                this.te.m_6596_();
            }
        }

        public boolean m_6542_(Player playerEntity) {
            return true;
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return index < this.inv.length && (this.inv[index].m_41619_() ? this.lockedInv[index].m_41619_() || SlottedChestContainer.doStackContentsMatch(stack, this.lockedInv[index]) : SlottedChestContainer.doStackContentsMatch(stack, this.inv[index]));
        }

        public void m_6211_() {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = ItemStack.f_41583_;
                this.lockedInv[i] = ItemStack.f_41583_;
            }
            this.filterChanged();
        }

        public boolean m_7983_() {
            for (ItemStack itemStack : this.inv) {
                if (itemStack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public void filterChanged() {
            if (this.te != null) {
                this.te.filterChanged();
            }
        }
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 54;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < 54 ? SlottedChestTileEntity.this.inv[slot] : ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 54 || stack.m_41619_() || !ItemStack.m_41746_((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot])) {
                return stack;
            }
            int change = Math.min(stack.m_41741_() - SlottedChestTileEntity.this.inv[slot].m_41613_(), stack.m_41613_());
            if (!simulate) {
                if (SlottedChestTileEntity.this.inv[slot].m_41619_()) {
                    SlottedChestTileEntity.this.inv[slot] = stack.m_41777_();
                } else {
                    SlottedChestTileEntity.this.inv[slot].m_41769_(change);
                }
            }
            ItemStack out = stack.m_41777_();
            out.m_41774_(change);
            return stack.m_41613_() == change ? ItemStack.f_41583_ : out;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 54 || SlottedChestTileEntity.this.inv[slot].m_41619_()) {
                return ItemStack.f_41583_;
            }
            int change = Math.min(SlottedChestTileEntity.this.inv[slot].m_41613_(), amount);
            ItemStack out = SlottedChestTileEntity.this.inv[slot].m_41777_();
            out.m_41764_(change);
            if (!simulate) {
                SlottedChestTileEntity.this.inv[slot].m_41774_(change);
            }
            return change == 0 ? ItemStack.f_41583_ : out;
        }

        public int getSlotLimit(int slot) {
            return slot < 54 ? 64 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < 54 && ItemStack.m_41746_((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot]) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)SlottedChestTileEntity.this.lockedInv[slot]);
        }
    }
}

