/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.blocks.redstone.PulseCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.gui.container.PulseCircuitContainer;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.tileentities.ITickableTileEntity;
import com.Da_Technomancer.essentials.tileentities.redstone.CircuitTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class PulseCircuitTileEntity
extends CircuitTileEntity
implements MenuProvider,
INBTReceiver,
ITickableTileEntity {
    @ObjectHolder(value="pulse_circuit")
    public static BlockEntityType<PulseCircuitTileEntity> TYPE = null;
    private static final int MIN_DURATION = 1;
    public int settingDuration = 1;
    public String settingStrDuration = "1";
    private long ticksExisted = 0L;
    private long pulseStTime = -10L;
    private boolean hadInput = false;

    public PulseCircuitTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public float currentOutput(int offset) {
        long currTime = this.ticksExisted + (long)offset;
        return this.pulseStTime <= currTime && (long)this.settingDuration > (currTime - this.pulseStTime - 1L) / 2L ? 1.0f : 0.0f;
    }

    private PulseCircuit.Edge getEdge() {
        Block b = this.m_58900_().m_60734_();
        if (b instanceof PulseCircuit) {
            return ((PulseCircuit)b).edge;
        }
        this.m_7651_();
        return PulseCircuit.Edge.RISING;
    }

    @Override
    public void handleInputChange(TickPriority priority) {
        boolean activeInput;
        float[] inputs = this.getInputs(this.getOwner());
        float input = inputs[1];
        boolean bl = activeInput = input > 0.0f;
        if (activeInput != this.hadInput) {
            this.hadInput = activeInput;
            boolean addPulse = activeInput ? this.getEdge().start : this.getEdge().end;
            if (addPulse) {
                this.pulseStTime = this.ticksExisted;
            }
            this.m_6596_();
        }
    }

    @Override
    public void tick() {
        ++this.ticksExisted;
        if (!this.f_58857_.f_46443_ && RedstoneUtil.didChange(this.currentOutput(-2), this.currentOutput(-1))) {
            this.recalculateOutput();
            this.m_6596_();
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128405_("setting_d", this.settingDuration);
        nbt.m_128359_("setting_s_d", this.settingStrDuration);
        nbt.m_128356_("existed", this.ticksExisted);
        nbt.m_128356_("st_time", this.pulseStTime);
        nbt.m_128379_("input", this.hadInput);
        return nbt;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.settingDuration = nbt.m_128451_("setting_d");
        this.settingStrDuration = nbt.m_128461_("setting_s_d");
        this.ticksExisted = nbt.m_128454_("existed");
        this.pulseStTime = nbt.m_128454_("st_time");
        this.hadInput = nbt.m_128471_("input");
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.pulse_circuit_" + this.getEdge().name);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new PulseCircuitContainer(id, playerInv, CircuitContainer.encodeData(CircuitContainer.createEmptyBuf(), this.f_58858_, this.settingStrDuration));
    }

    @Override
    public void receiveNBT(CompoundTag nbt, @Nullable ServerPlayer sender) {
        this.settingDuration = Math.max(Math.round(nbt.m_128457_("value_0")), 1);
        this.settingStrDuration = nbt.m_128461_("text_0");
        this.m_6596_();
        this.recalculateOutput();
    }
}

