/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.blocks;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.util.GelPortalSize;
import com.legacy.structure_gel.util.GelTeleporter;
import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.GelEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GelPortalBlock
extends NetherPortalBlock {
    private final Function<ServerWorld, GelTeleporter> teleporter;

    public GelPortalBlock(AbstractBlock.Properties properties, Function<ServerWorld, GelTeleporter> teleporter) {
        super(properties);
        this.teleporter = teleporter;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPortal(float timeInPortal, int scaledHeight, int scaledWidth) {
        Minecraft mc = Minecraft.func_71410_x();
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = this.getPortalTexture();
        float f = sprite.func_94209_e();
        float f1 = sprite.func_94206_g();
        float f2 = sprite.func_94212_f();
        float f3 = sprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffBuilder = tessellator.func_178180_c();
        buffBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffBuilder.func_225582_a_(0.0, (double)scaledHeight, -90.0).func_225583_a_(f, f3).func_181675_d();
        buffBuilder.func_225582_a_((double)scaledWidth, (double)scaledHeight, -90.0).func_225583_a_(f2, f3).func_181675_d();
        buffBuilder.func_225582_a_((double)scaledWidth, 0.0, -90.0).func_225583_a_(f2, f1).func_181675_d();
        buffBuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(f, f1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getPortalTexture() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.func_175602_ab().func_175023_a().func_178122_a(this.func_176223_P());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISound getTriggerSound() {
        return SimpleSound.func_239532_b_((SoundEvent)SoundEvents.field_187814_ei, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISound getTravelSound() {
        return SimpleSound.func_239532_b_((SoundEvent)SoundEvents.field_187812_eh, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    public static boolean fillPortal(World world, BlockPos pos, GelPortalBlock portal, List<Block> allowedBlocks) {
        GelTeleporter teleporter = portal.getTeleporter(null);
        return (world.func_234923_W_() == teleporter.getDimension1().get() || world.func_234923_W_() == teleporter.getDimension2().get()) && GelPortalSize.trySpawnPortal((IWorld)world, pos, portal, allowedBlocks);
    }

    public final GelTeleporter getTeleporter(ServerWorld world) {
        return this.teleporter.apply(world);
    }

    public Supplier<BlockState> getFrameBlock() {
        return this.teleporter.apply(null).getFrameBlock();
    }

    public int getMaxTimeInside(Entity entityIn) {
        return entityIn.func_82145_z();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis facingAxis = facing.func_176740_k();
        Direction.Axis portalAxis = (Direction.Axis)state.func_177229_b((Property)field_176550_a);
        boolean flag = portalAxis != facingAxis && facingAxis.func_176722_c();
        return !flag && !facingState.func_203425_a((Block)this) && !new GelPortalSize(world, currentPos, portalAxis, this.getFrameBlock().get().func_177230_c(), this, (List<Block>)ImmutableList.of()).isPortalComplete() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        GelCapability.ifPresent(entity, gelEntity -> {
            if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
                entity.func_181015_d(pos);
                gelEntity.setPortal(this);
                GelEntity.setPortalClient(entity, this);
            }
        });
    }
}

