/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GetSpawnsCommand {
    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.func_197057_a((String)"getspawns").executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSource>)context, EntityClassification.values()));
        for (EntityClassification classification : EntityClassification.values()) {
            command.then(Commands.func_197057_a((String)classification.func_220363_a()).executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSource>)context, classification)));
        }
        return command;
    }

    private static int getSpawns(CommandContext<CommandSource> context, EntityClassification ... classifications) {
        LinkedHashMap<EntityClassification, List<MobSpawnInfo.Spawners>> map = new LinkedHashMap<EntityClassification, List<MobSpawnInfo.Spawners>>();
        for (EntityClassification classification : classifications) {
            List<MobSpawnInfo.Spawners> list = GetSpawnsCommand.getSpawnList(classification, context);
            if (list.isEmpty()) continue;
            map.put(classification, list);
        }
        if (!map.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("--Spawn Data--"), true);
            map.entrySet().stream().sorted(new ClassificationComparator()).forEach(e -> GetSpawnsCommand.printSpawns((EntityClassification)e.getKey(), (List)e.getValue(), context));
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("No spawn data."), true);
        return 1;
    }

    private static List<MobSpawnInfo.Spawners> getSpawnList(EntityClassification classification, CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        BlockPos pos = new BlockPos(((CommandSource)context.getSource()).func_197036_d());
        Biome biome = world.func_226691_t_(pos);
        ChunkGenerator chunkGen = world.func_72863_F().field_186029_c;
        StructureManager manager = world.func_241112_a_();
        List list = chunkGen.func_230353_a_(biome, manager, classification, pos);
        return ForgeEventFactory.getPotentialSpawns((IWorld)world, (EntityClassification)classification, (BlockPos)pos, (List)list);
    }

    private static void printSpawns(EntityClassification classification, List<MobSpawnInfo.Spawners> spawns, CommandContext<CommandSource> context) {
        if (!spawns.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("[" + classification.func_220363_a() + "]").func_240699_a_(TextFormatting.GREEN), true);
            spawns.stream().sorted(new SpawnInfoComparator()).forEach(spawn -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(String.format(" - %s, weight:%d, min:%d, max:%d", spawn.field_242588_c.getRegistryName(), spawn.field_76292_a, spawn.field_242589_d, spawn.field_242590_e)), true));
        }
    }

    private static class ClassificationComparator<T extends Map.Entry<EntityClassification, List<MobSpawnInfo.Spawners>>>
    implements Comparator<T> {
        private ClassificationComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((EntityClassification)o1.getKey()).func_220363_a().compareTo(((EntityClassification)o2.getKey()).func_220363_a());
        }
    }

    private static class SpawnInfoComparator<T extends MobSpawnInfo.Spawners>
    implements Comparator<T> {
        private SpawnInfoComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((MobSpawnInfo.Spawners)o1).field_242588_c.getRegistryName().toString().compareTo(((MobSpawnInfo.Spawners)o2).field_242588_c.getRegistryName().toString());
        }
    }
}

