/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.client.FarlandersClientEvents;
import com.legacy.farlanders.client.render.FarlanderEntityRendering;
import com.legacy.farlanders.event.FarlandersEvents;
import com.legacy.farlanders.registry.FarlandersFeatures;
import com.legacy.farlanders.util.FarlandersRankings;
import java.util.logging.Logger;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="farlanders")
public class TheFarlandersMod {
    public static final String NAME = "The Farlanders";
    public static final String MODID = "farlanders";
    public static final Logger LOGGER = Logger.getLogger("farlanders");

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static String find(String name) {
        return "farlanders:" + name;
    }

    public TheFarlandersMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FarlandersConfig.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TheFarlandersMod::commonInit);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(TheFarlandersMod::clientInit));
    }

    public static void clientInit(FMLClientSetupEvent event) {
        FarlanderEntityRendering.init();
        MinecraftForge.EVENT_BUS.register((Object)new FarlandersClientEvents());
    }

    public static void commonInit(FMLCommonSetupEvent event) {
        FarlandersRankings.init();
        MinecraftForge.EVENT_BUS.addListener(biomeEvent -> FarlandersFeatures.addFeatures(biomeEvent));
        MinecraftForge.EVENT_BUS.register((Object)new FarlandersEvents());
        FarlandersFeatures.Configured.init();
    }
}

