/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.util;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class BaseEndermanEntity
extends MonsterEntity
implements IAngerable {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(BaseEndermanEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(BaseEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_226535_bx_ = EntityDataManager.func_187226_a(BaseEndermanEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final Predicate<LivingEntity> PLAYER_SPAWNED = p_213626_0_ -> p_213626_0_ instanceof EndermiteEntity && ((EndermiteEntity)p_213626_0_).func_175495_n();
    protected int lastCreepySound = Integer.MIN_VALUE;
    private int targetChangeTime;
    private static final RangedInteger field_234286_bz_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public BaseEndermanEntity(EntityType<? extends BaseEndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((BaseEndermanEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, PLAYER_SPAWNED));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, false));
        this.registerExtraGoals();
    }

    protected void registerExtraGoals() {
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new FindPlayerGoal(this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributeMap() {
        return EndermanEntity.func_234287_m_();
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
        if (entitylivingbaseIn == null) {
            this.targetChangeTime = 0;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)false);
            this.field_70180_af.func_187227_b(field_226535_bx_, (Object)false);
            modifiableattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.targetChangeTime = this.field_70173_aa;
            this.field_70180_af.func_187227_b(SCREAMING, (Object)true);
            if (!modifiableattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                modifiableattributeinstance.func_233767_b_(ATTACKING_SPEED_BOOST);
            }
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, Optional.empty());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
        this.field_70180_af.func_187214_a(field_226535_bx_, (Object)false);
    }

    protected void onPlayerSeen(PlayerEntity player) {
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234286_bz_.func_233018_a_(this.field_70146_Z));
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230259_a_(@Nullable UUID targetUUID) {
        this.angerTarget = targetUUID;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.func_226537_et_() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            compound.func_218657_a("carriedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("carriedBlockState"))).func_196958_f()) {
            blockstate = null;
        }
        this.setHeldBlockState(blockstate);
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    protected boolean shouldAttackPlayer(PlayerEntity player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Blocks.field_196625_cS.func_199767_j()) {
            return false;
        }
        Vector3d vector3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_226280_cw_() - player.func_226280_cw_(), this.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this) : false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.55f;
    }

    protected void spawnParticles() {
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        this.field_70703_bu = false;
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
        super.func_70636_d();
    }

    public boolean func_230270_dK_() {
        return true;
    }

    protected void func_70619_bc() {
        float f;
        if (this.field_70170_p.func_72935_r() && this.field_70173_aa >= this.targetChangeTime + 600 && (f = this.func_70013_c()) > 0.5f && this.field_70170_p.func_226660_f_(this.func_233580_cy_()) && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.func_70624_b(null);
            this.teleportRandomly();
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportToEntity(Entity entityIn) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - entityIn.func_226277_ct_(), this.func_226283_e_(0.5) - entityIn.func_226280_cw_(), this.func_226281_cx_() - entityIn.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double radius = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * radius;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * radius;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * radius;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            this.func_199703_a((IItemProvider)blockstate.func_177230_c());
        }
    }

    public void setHeldBlockState(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    public BlockState getHeldBlockState() {
        return ((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orElse(null);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (!this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public boolean func_226537_et_() {
        return (Boolean)this.field_70180_af.func_187225_a(field_226535_bx_);
    }

    public void func_226538_eu_() {
        this.field_70180_af.func_187227_b(field_226535_bx_, (Object)true);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.getHeldBlockState() != null;
    }

    protected static class TakeBlockGoal
    extends Goal {
        private final BaseEndermanEntity enderman;

        public TakeBlockGoal(BaseEndermanEntity endermanIn) {
            this.enderman = endermanIn;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.func_226277_ct_() - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.func_226278_cu_() + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.func_226281_cx_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vector3d vector3d = new Vector3d((double)MathHelper.func_76128_c((double)this.enderman.func_226277_ct_()) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.enderman.func_226281_cx_()) + 0.5);
            Vector3d vector3d1 = new Vector3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.enderman));
            boolean flag = blockraytraceresult.func_216350_a().equals((Object)blockpos);
            if (block.func_203417_a((ITag)BlockTags.field_201151_l) && flag) {
                this.enderman.setHeldBlockState(blockstate);
                world.func_217377_a(blockpos, false);
            }
        }
    }

    protected static class StareGoal
    extends Goal {
        private final BaseEndermanEntity enderman;
        private LivingEntity targetPlayer;

        public StareGoal(BaseEndermanEntity endermanIn) {
            this.enderman = endermanIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.enderman.func_70638_az();
            if (!(this.targetPlayer instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.targetPlayer.func_70068_e((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.shouldAttackPlayer((PlayerEntity)this.targetPlayer);
        }

        public void func_75249_e() {
            this.enderman.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.enderman.func_70671_ap().func_220679_a(this.targetPlayer.func_226277_ct_(), this.targetPlayer.func_226280_cw_(), this.targetPlayer.func_226281_cx_());
        }
    }

    protected static class PlaceBlockGoal
    extends Goal {
        private final BaseEndermanEntity enderman;

        public PlaceBlockGoal(BaseEndermanEntity p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.func_226278_cu_() + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = world.func_180495_p(blockpos1);
            BlockState blockstate2 = this.enderman.getHeldBlockState();
            if (blockstate2 != null && this.canPlaceBlockAtPos((IWorldReader)world, blockpos, blockstate2 = Block.func_199770_b((BlockState)blockstate2, (IWorld)this.enderman.field_70170_p, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                world.func_180501_a(blockpos, blockstate2, 3);
                this.enderman.setHeldBlockState(null);
            }
        }

        private boolean canPlaceBlockAtPos(IWorldReader worldIn, BlockPos posIn, BlockState state1In, BlockState state2In, BlockState state3In, BlockPos pos2) {
            return state2In.isAir((IBlockReader)worldIn, posIn) && !state3In.isAir((IBlockReader)worldIn, pos2) && state3In.func_235785_r_((IBlockReader)worldIn, pos2) && state1In.func_196955_c(worldIn, posIn);
        }
    }

    protected static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final BaseEndermanEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate field_220791_m;
        private final EntityPredicate field_220792_n = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(BaseEndermanEntity endermanIn) {
            super((MobEntity)endermanIn, PlayerEntity.class, false);
            this.enderman = endermanIn;
            this.field_220791_m = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> endermanIn.shouldAttackPlayer((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.field_220791_m, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.func_226538_eu_();
            if (this.player != null && !this.enderman.field_70170_p.field_72995_K) {
                this.enderman.onPlayerSeen(this.player);
            }
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.field_220792_n.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.enderman.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.shouldAttackPlayer((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

