/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.util;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public abstract class BreedableVillagerEntity
extends AbstractVillagerEntity {
    private int inLove;
    private UUID playerInLove;

    public BreedableVillagerEntity(EntityType<? extends AbstractVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70619_bc() {
        if (this.func_70874_b() != 0) {
            this.inLove = 0;
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70874_b() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("InLove", this.inLove);
        if (this.playerInLove != null) {
            compound.func_186854_a("LoveCause", this.playerInLove);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.inLove = compound.func_74762_e("InLove");
        this.playerInLove = compound.func_186855_b("LoveCause") ? compound.func_186857_a("LoveCause") : null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.inLove = 0;
        return super.func_70097_a(source, amount);
    }

    public boolean isBreedingItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151034_e;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (this.isBreedingItem(itemstack)) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.canFallInLove()) {
                this.consumeItemFromStack(p_230254_1_, itemstack);
                this.setInLove(p_230254_1_);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70631_g_()) {
                this.consumeItemFromStack(p_230254_1_, itemstack);
                this.func_175501_a((int)((float)(-i / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public boolean canFallInLove() {
        return this.inLove <= 0;
    }

    public void setInLove(@Nullable PlayerEntity player) {
        this.inLove = 600;
        if (player != null) {
            this.playerInLove = player.func_110124_au();
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void setInLove(int ticks) {
        this.inLove = ticks;
    }

    public int inLove() {
        return this.inLove;
    }

    @Nullable
    public ServerPlayerEntity getLoveCause() {
        if (this.playerInLove == null) {
            return null;
        }
        PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.playerInLove);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public boolean isInLove() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public boolean canMateWith(BreedableVillagerEntity otherVillager) {
        if (otherVillager == this) {
            return false;
        }
        if (((Object)((Object)otherVillager)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && otherVillager.isInLove();
    }

    public void func_234177_a_(ServerWorld world, BreedableVillagerEntity villager) {
        AgeableEntity ageableentity = this.func_241840_a(world, (AgeableEntity)villager);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)this, (MobEntity)villager, ageableentity);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        ageableentity = event.getChild();
        if (cancelled) {
            this.func_70873_a(6000);
            villager.func_70873_a(6000);
            this.resetInLove();
            villager.resetInLove();
            return;
        }
        if (ageableentity != null) {
            ServerPlayerEntity serverplayerentity = this.getLoveCause();
            if (serverplayerentity == null && villager.getLoveCause() != null) {
                serverplayerentity = villager.getLoveCause();
            }
            this.func_70873_a(6000);
            villager.func_70873_a(6000);
            this.resetInLove();
            villager.resetInLove();
            ageableentity.func_82227_f(true);
            ageableentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            world.func_242417_l((Entity)ageableentity);
            world.func_72960_a((Entity)this, (byte)18);
            if (world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_70681_au().nextInt(7) + 1));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

