/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.registry;

import com.legacy.farlanders.FarlandersRegistry;
import com.legacy.farlanders.registry.FarlandersBlocks;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.farlanders.world.structure.FarlanderLootFeature;
import com.legacy.farlanders.world.structure.TitanSpireFeature;
import com.legacy.structure_gel.access_helpers.BiomeAccessHelper;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.mojang.serialization.Codec;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FarlandersFeatures {
    public static final Feature<NoFeatureConfig> LOOT_WELL = new FarlanderLootFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, Blocks.field_196658_i.func_176223_P());
    public static final Feature<NoFeatureConfig> TITAN_SPIRE = new TitanSpireFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Feature<?>> event) {
        FarlandersRegistry.register(event.getRegistry(), "loot_well", LOOT_WELL);
        FarlandersRegistry.register(event.getRegistry(), "titan_spire", TITAN_SPIRE);
    }

    public static void addFeatures(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.MUSHROOM) {
            return;
        }
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (!(event.getCategory() == Biome.Category.THEEND || event.getCategory() == Biome.Category.NETHER || event.getCategory() == Biome.Category.NONE || event.getCategory() == Biome.Category.RIVER || event.getCategory() == Biome.Category.OCEAN || FarlandersFeatures.containsBiome(BiomeDictionary.NETHER, event) || FarlandersFeatures.containsBiome(BiomeDictionary.END, event) || FarlandersFeatures.containsBiome(BiomeDictionary.COLD, event) || FarlandersFeatures.containsBiome(BiomeDictionary.RIVER, event) || FarlandersFeatures.containsBiome(BiomeDictionary.OCEAN, event))) {
            if (FarlandersFeatures.containsBiome(BiomeDictionary.PLAINS, event) && !FarlandersFeatures.containsBiome(BiomeDictionary.COLD, event) && !FarlandersFeatures.containsBiome(BiomeDictionary.SNOWY, event) && !FarlandersFeatures.containsBiome(BiomeDictionary.HOT, event) && event.getCategory() != Biome.Category.FOREST) {
                BiomeAccessHelper.addStructure((BiomeLoadingEvent)event, (StructureFeature)FarlandersStructures.FARLANDER_VILLAGE.getStructureFeature());
            }
            BiomeAccessHelper.addStructure((BiomeLoadingEvent)event, (StructureFeature)FarlandersStructures.SMALL_HOUSE.getStructureFeature());
            builder.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.LOOT_WELL);
            builder.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.TITAN_SPIRE);
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(FarlandersEntityTypes.ENDERMINION, 2, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(FarlandersEntityTypes.MYSTIC_ENDERMINION, 1, 1, 1));
            spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(FarlandersEntityTypes.WANDERER, 3, 1, 1));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(FarlandersEntityTypes.LOOTER, 20, 1, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(FarlandersEntityTypes.REBEL, 20, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(FarlandersEntityTypes.CLASSIC_ENDERMAN, 7, 1, 4));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(FarlandersEntityTypes.FANMADE_ENDERMAN, 5, 1, 2));
            spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(FarlandersEntityTypes.MYSTIC_ENDERMAN, 3, 1, 2));
        }
        if (BiomeDictionary.MOUNTAIN.getBiomes().contains(event.getName())) {
            builder.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, Configured.ENDUMIUM_ORE);
        }
    }

    public static boolean doesBiomeMatch(Biome biomeIn, RegistryKey<Biome> wantedBiomeIn) {
        return biomeIn.toString().matches(wantedBiomeIn.func_240901_a_().toString());
    }

    public static boolean containsBiome(BiomeType biomeIn, BiomeLoadingEvent eventIn) {
        return biomeIn.getBiomes().contains(eventIn.getName());
    }

    public static class Configured {
        public static final ConfiguredFeature<?, ?> LOOT_WELL = (ConfiguredFeature)LOOT_WELL.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> TITAN_SPIRE = TITAN_SPIRE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(1)));
        public static final ConfiguredFeature<?, ?> ENDUMIUM_ORE = Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), FarlandersBlocks.endumium_ore.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e));

        public static void init() {
            Configured.register("loot_well", LOOT_WELL);
            Configured.register("titan_spire", TITAN_SPIRE);
            Configured.register("endumium_ore", ENDUMIUM_ORE);
        }

        private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> register(String nameIn, ConfiguredFeature<FC, ?> featureIn) {
            return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)nameIn, featureIn);
        }
    }
}

