/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.google.common.collect.Lists;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.ElderFarlanderEntity;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.EnderGuardianEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.registry.FarlandersEntityTypes;
import com.legacy.farlanders.registry.FarlandersStructures;
import com.legacy.structure_gel.util.ConfigTemplates;
import com.legacy.structure_gel.worldgen.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.worldgen.jigsaw.GelConfigJigsawStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class FarlanderVillageStructure
extends GelConfigJigsawStructure {
    public FarlanderVillageStructure(Codec<VillageConfig> configFactoryIn, ConfigTemplates.StructureConfig config) {
        super(configFactoryIn, config, 0, true, true);
        this.setSpawnList(EntityClassification.MONSTER, Lists.newArrayList());
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGen, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ, Biome biomeIn, ChunkPos chunkPos, VillageConfig config) {
        return super.func_230363_a_(chunkGen, biomeProvider, seed, sharedSeedRand, chunkPosX, chunkPosZ, biomeIn, chunkPos, (IFeatureConfig)config) && !this.isVillageClose(chunkGen, seed, sharedSeedRand, chunkPosX, chunkPosZ);
    }

    private boolean isVillageClose(ChunkGenerator chunkGen, long seed, SharedSeedRandom sharedSeedRand, int chunkPosX, int chunkPosZ) {
        StructureSeparationSettings structureseparationsettings = chunkGen.func_235957_b_().func_236197_a_(Structure.field_236381_q_);
        if (structureseparationsettings == null) {
            return false;
        }
        int range = 5;
        for (int x = chunkPosX - range; x <= chunkPosX + range; ++x) {
            for (int z = chunkPosZ - range; z <= chunkPosZ + range; ++z) {
                ChunkPos chunkpos = Structure.field_236381_q_.func_236392_a_(structureseparationsettings, seed, sharedSeedRand, x, z);
                if (x != chunkpos.field_77276_a || z != chunkpos.field_77275_b) continue;
                return true;
            }
        }
        return false;
    }

    public int getSeed() {
        return 997638;
    }

    public JigsawManager.IPieceFactory getPieceType() {
        return Piece::new;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt);
        }

        public IStructurePieceType func_214807_k() {
            return FarlandersStructures.FARLANDER_VILLAGE.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox bounds) {
            IColoredEyes entity;
            if (key.equals("farlander")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (FarlanderEntity)this.createEntity(FarlandersEntityTypes.FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("elder")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (ElderFarlanderEntity)this.createEntity(FarlandersEntityTypes.ELDER_FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("golem")) {
                this.setAir((IWorld)worldIn, pos);
                entity = (EnderGolemEntity)this.createEntity(FarlandersEntityTypes.ENDER_GOLEM, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.contains("guardian")) {
                if (key.contains("up")) {
                    worldIn.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 3);
                    entity = (EnderGuardianEntity)this.createEntity(FarlandersEntityTypes.ENDER_GUARDIAN, worldIn, pos.func_177984_a(), this.field_214834_c);
                    ((EnderGuardianEntity)entity).func_213386_a(worldIn, worldIn.func_175649_E(pos.func_177984_a()), SpawnReason.STRUCTURE, null, null);
                    entity.func_110163_bv();
                    worldIn.func_217376_c((Entity)entity);
                } else {
                    this.setAir((IWorld)worldIn, pos);
                    entity = (EnderGuardianEntity)this.createEntity(FarlandersEntityTypes.ENDER_GUARDIAN, worldIn, pos, this.field_214834_c);
                    ((EnderGuardianEntity)entity).func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                    entity.func_110163_bv();
                    worldIn.func_217376_c((Entity)entity);
                }
            }
            if (key.equals("elder-loot")) {
                this.setAir((IWorld)worldIn, pos);
                ChestTileEntity tile = (ChestTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                tile.func_189404_a(TheFarlandersMod.locate("chests/elder_house_chest"), worldIn.func_201674_k().nextLong());
            }
        }
    }
}

