/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid;

import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.apiimpl.HealingItemApiHelperImpl;
import ichttt.mods.firstaid.common.apiimpl.RegistryManager;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.network.MessageAddHealth;
import ichttt.mods.firstaid.common.network.MessageApplyAbsorption;
import ichttt.mods.firstaid.common.network.MessageApplyHealingItem;
import ichttt.mods.firstaid.common.network.MessageClientRequest;
import ichttt.mods.firstaid.common.network.MessageConfiguration;
import ichttt.mods.firstaid.common.network.MessagePlayHurtSound;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import ichttt.mods.firstaid.common.potion.FirstAidPotion;
import ichttt.mods.firstaid.common.potion.PotionPoisonPatched;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="firstaid")
public class FirstAid {
    public static final String MODID = "firstaid";
    public static final Logger LOGGER = LogManager.getLogger((String)"firstaid");
    public static final ItemGroup ITEM_GROUP = new ItemGroup("firstaid"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)FirstAidItems.BANDAGE);
        }
    };
    private static final String NETWORKING_MAJOR = "3.";
    private static final String NETWORKING_MINOR = "0";
    private static final String NETWORKING_VERSION = "3.0";
    public static final SimpleChannel NETWORKING = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("firstaid", "channel"), () -> "3.0", s -> s.startsWith(NETWORKING_MAJOR), s -> s.equals(NETWORKING_VERSION));
    public static boolean morpheusLoaded = false;
    public static boolean isSynced = false;

    public FirstAid() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
        bus.addListener(this::loadComplete);
        bus.addGenericListener(Item.class, this::registerItems);
        bus.addGenericListener(Effect.class, this::registerPotion);
        bus.addGenericListener(SoundEvent.class, this::registerSound);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, FirstAidConfig.serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FirstAidConfig.generalSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, FirstAidConfig.clientSpec);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(ClientHooks::setup));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(ClientHooks::lateSetup));
        HealingItemApiHelperImpl.init();
        RegistryManager.setupRegistries();
    }

    public void init(FMLCommonSetupEvent event) {
        LOGGER.info("{} starting...", (Object)MODID);
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            LOGGER.warn("DEBUG MODE ENABLED");
            LOGGER.warn("FirstAid may be slower than usual and will produce much noisier logs if debug mode is enabled");
            LOGGER.warn("Disable debug in firstaid config");
        }
        CapabilityManager.INSTANCE.register(AbstractPlayerDamageModel.class, (Capability.IStorage)new Capability.IStorage<AbstractPlayerDamageModel>(){

            @Nullable
            public INBT writeNBT(Capability<AbstractPlayerDamageModel> capability, AbstractPlayerDamageModel instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<AbstractPlayerDamageModel> capability, AbstractPlayerDamageModel instance, Direction side, INBT nbt) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }, () -> {
            throw new UnsupportedOperationException("No default implementation");
        });
        int i = 0;
        NETWORKING.registerMessage(++i, MessageUpdatePart.class, MessageUpdatePart::encode, MessageUpdatePart::new, (message, supplier) -> MessageUpdatePart.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageApplyHealingItem.class, MessageApplyHealingItem::encode, MessageApplyHealingItem::new, (message, supplier) -> MessageApplyHealingItem.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageConfiguration.class, MessageConfiguration::encode, MessageConfiguration::new, (message, supplier) -> MessageConfiguration.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageApplyAbsorption.class, MessageApplyAbsorption::encode, MessageApplyAbsorption::new, (message, supplier) -> MessageApplyAbsorption.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageAddHealth.class, MessageAddHealth::encode, MessageAddHealth::new, (message, supplier) -> MessageAddHealth.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessagePlayHurtSound.class, MessagePlayHurtSound::encode, MessagePlayHurtSound::new, (message, supplier) -> MessagePlayHurtSound.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageClientRequest.class, MessageClientRequest::encode, MessageClientRequest::new, (message, supplier) -> MessageClientRequest.Handler.onMessage(message, supplier));
        NETWORKING.registerMessage(++i, MessageSyncDamageModel.class, MessageSyncDamageModel::encode, MessageSyncDamageModel::new, (message, supplier) -> MessageSyncDamageModel.Handler.onMessage(message, supplier));
        if (ModList.get().isLoaded("morpheus")) {
            morpheusLoaded = true;
        }
        RegistryManager.registerDefaults();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        RegistryManager.finalizeRegistries();
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        FirstAidItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    public void registerPotion(RegistryEvent.Register<Effect> event) {
        event.getRegistry().register((IForgeRegistryEntry)new FirstAidPotion(EffectType.BENEFICIAL, 3549, FirstAidItems.MORPHINE));
        event.getRegistry().register((IForgeRegistryEntry)PotionPoisonPatched.INSTANCE);
    }

    public void registerSound(RegistryEvent.Register<SoundEvent> event) {
        ResourceLocation res = new ResourceLocation(MODID, "debuff.heartbeat");
        event.getRegistry().register(new SoundEvent(res).setRegistryName(res));
    }
}

