/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.api.enums;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EquipmentSlotType;

public enum EnumPlayerPart {
    HEAD(EquipmentSlotType.HEAD),
    LEFT_ARM(EquipmentSlotType.CHEST),
    LEFT_LEG(EquipmentSlotType.LEGS),
    LEFT_FOOT(EquipmentSlotType.FEET),
    BODY(EquipmentSlotType.CHEST),
    RIGHT_ARM(EquipmentSlotType.CHEST),
    RIGHT_LEG(EquipmentSlotType.LEGS),
    RIGHT_FOOT(EquipmentSlotType.FEET);

    public static final EnumPlayerPart[] VALUES;
    private ImmutableList<EnumPlayerPart> neighbours;
    public final EquipmentSlotType slot;

    private EnumPlayerPart(EquipmentSlotType slot) {
        this.slot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<EnumPlayerPart> getNeighbours() {
        if (this.neighbours == null) {
            EnumPlayerPart enumPlayerPart = this;
            synchronized (enumPlayerPart) {
                if (this.neighbours == null) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(this.getNeighboursDown());
                    builder.addAll(this.getNeighboursUp());
                    builder.addAll(this.getNeighboursLeft());
                    builder.addAll(this.getNeighboursRight());
                    this.neighbours = builder.build();
                }
            }
        }
        return this.neighbours;
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursUp() {
        switch (this) {
            case BODY: {
                return Collections.singletonList(HEAD);
            }
            case LEFT_LEG: 
            case RIGHT_LEG: {
                return Collections.singletonList(BODY);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(RIGHT_LEG);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursDown() {
        switch (this) {
            case HEAD: {
                return Collections.singletonList(BODY);
            }
            case BODY: {
                return Arrays.asList(LEFT_LEG, RIGHT_LEG);
            }
            case LEFT_LEG: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(RIGHT_FOOT);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursLeft() {
        switch (this) {
            case RIGHT_ARM: {
                return Collections.singletonList(BODY);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(LEFT_ARM);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursRight() {
        switch (this) {
            case LEFT_ARM: {
                return Collections.singletonList(BODY);
            }
            case LEFT_LEG: {
                return Collections.singletonList(RIGHT_LEG);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(RIGHT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(RIGHT_ARM);
            }
        }
        return Collections.emptyList();
    }

    @Deprecated
    public EnumPlayerPart getUp() {
        if (this == BODY) {
            throw new RuntimeException("There is no part up from " + (Object)((Object)this));
        }
        return VALUES[this.ordinal() - 1];
    }

    @Deprecated
    public EnumPlayerPart getDown() {
        if (this == LEFT_FOOT) {
            throw new RuntimeException("There is no part down from " + (Object)((Object)this));
        }
        return VALUES[this.ordinal() + 1];
    }

    @Deprecated
    public EnumPlayerPart getLeft() {
        return VALUES[this.ordinal() - 4];
    }

    @Deprecated
    public EnumPlayerPart getRight() {
        return VALUES[this.ordinal() + 4];
    }

    static {
        for (EnumPlayerPart value : VALUES = EnumPlayerPart.values()) {
            ImmutableList<EnumPlayerPart> neighbours = value.getNeighbours();
            if (neighbours.contains((Object)value)) {
                throw new RuntimeException((Object)((Object)value) + " contains itself as a neighbour!");
            }
            if (neighbours.isEmpty()) {
                throw new RuntimeException((Object)((Object)value) + " does not have any neighbours!");
            }
            if (EnumSet.copyOf(neighbours).size() != neighbours.size()) {
                throw new RuntimeException((Object)((Object)value) + " neighbours contain the same part multiple times!");
            }
            EnumSet<EnumPlayerPart> hopefullyAllParts = EnumSet.copyOf(neighbours);
            int oldSize = -1;
            while (oldSize != hopefullyAllParts.size()) {
                oldSize = hopefullyAllParts.size();
                EnumSet<EnumPlayerPart> neighboursOfNeighbours = EnumSet.noneOf(EnumPlayerPart.class);
                for (EnumPlayerPart part : hopefullyAllParts) {
                    neighboursOfNeighbours.addAll((Collection<EnumPlayerPart>)part.getNeighbours());
                }
                hopefullyAllParts.addAll(neighboursOfNeighbours);
            }
            if (hopefullyAllParts.size() == VALUES.length) continue;
            throw new RuntimeException((Object)((Object)value) + " could not read all player parts " + Arrays.toString((Object[])hopefullyAllParts.toArray(new EnumPlayerPart[0])));
        }
    }
}

