/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.GuiHoldButton;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.network.MessageApplyHealingItem;
import ichttt.mods.firstaid.common.network.MessageClientRequest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiHealthScreen
extends Screen {
    public static final int xSize = 256;
    public static final int ySize = 137;
    public static final ItemStack BED_ITEMSTACK = new ItemStack((IItemProvider)Items.field_196098_bI);
    private static final DecimalFormat FORMAT = new DecimalFormat("##.#");
    public static GuiHealthScreen INSTANCE;
    public static boolean isOpen;
    private final AbstractPlayerDamageModel damageModel;
    private final List<GuiHoldButton> holdButtons = new ArrayList<GuiHoldButton>();
    private final boolean disableButtons;
    private final float bedScaleFactor = EventCalendar.isGuiFun() ? 1.5f : 1.25f;
    public int guiLeft;
    public int guiTop;
    public AbstractButton cancelButton;
    private AbstractButton head;
    private AbstractButton leftArm;
    private AbstractButton leftLeg;
    private AbstractButton leftFoot;
    private AbstractButton body;
    private AbstractButton rightArm;
    private AbstractButton rightLeg;
    private AbstractButton rightFoot;
    private Hand activeHand;

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel) {
        super((ITextComponent)new TranslationTextComponent("firstaid.gui.healthscreen"));
        this.damageModel = damageModel;
        this.disableButtons = true;
    }

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel, Hand activeHand) {
        super((ITextComponent)new TranslationTextComponent("firstaid.gui.healthscreen"));
        this.damageModel = damageModel;
        this.activeHand = activeHand;
        this.disableButtons = false;
    }

    public void func_231160_c_() {
        isOpen = true;
        this.guiLeft = (this.field_230708_k_ - 256) / 2;
        this.guiTop = (this.field_230709_l_ - 137) / 2;
        this.head = new GuiHoldButton(1, this.guiLeft + 4, this.guiTop + 8, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.head"), false);
        this.func_230480_a_((Widget)this.head);
        this.leftArm = new GuiHoldButton(2, this.guiLeft + 4, this.guiTop + 33, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.left_arm"), false);
        this.func_230480_a_((Widget)this.leftArm);
        this.leftLeg = new GuiHoldButton(3, this.guiLeft + 4, this.guiTop + 58, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.left_leg"), false);
        this.func_230480_a_((Widget)this.leftLeg);
        this.leftFoot = new GuiHoldButton(4, this.guiLeft + 4, this.guiTop + 83, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.left_foot"), false);
        this.func_230480_a_((Widget)this.leftFoot);
        this.body = new GuiHoldButton(5, this.guiLeft + 199, this.guiTop + 8, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.body"), true);
        this.func_230480_a_((Widget)this.body);
        this.rightArm = new GuiHoldButton(6, this.guiLeft + 199, this.guiTop + 33, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.right_arm"), true);
        this.func_230480_a_((Widget)this.rightArm);
        this.rightLeg = new GuiHoldButton(7, this.guiLeft + 199, this.guiTop + 58, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.right_leg"), true);
        this.func_230480_a_((Widget)this.rightLeg);
        this.rightFoot = new GuiHoldButton(8, this.guiLeft + 199, this.guiTop + 83, 52, 20, (ITextComponent)new TranslationTextComponent("firstaid.gui.right_foot"), true);
        this.func_230480_a_((Widget)this.rightFoot);
        if (this.disableButtons) {
            this.head.field_230693_o_ = false;
            this.leftArm.field_230693_o_ = false;
            this.leftLeg.field_230693_o_ = false;
            this.leftFoot.field_230693_o_ = false;
            this.body.field_230693_o_ = false;
            this.rightArm.field_230693_o_ = false;
            this.rightLeg.field_230693_o_ = false;
            this.rightFoot.field_230693_o_ = false;
        }
        this.cancelButton = new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 50, 200, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.func_231175_as__());
        this.func_230480_a_((Widget)this.cancelButton);
        if (this.field_230706_i_.field_71474_y.field_74330_P) {
            Button refresh = new Button(this.guiLeft + 218, this.guiTop + 115, 36, 20, (ITextComponent)new StringTextComponent("resync"), button -> {
                FirstAid.NETWORKING.sendToServer((Object)new MessageClientRequest(MessageClientRequest.Type.REQUEST_REFRESH));
                FirstAid.LOGGER.info("Requesting refresh");
                this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Re-downloading health data from server..."), true);
                this.func_231175_as__();
            });
            this.func_230480_a_((Widget)refresh);
        }
        this.holdButtons.clear();
        for (Widget button2 : this.field_230710_m_) {
            Integer holdTime;
            if (!(button2 instanceof GuiHoldButton)) continue;
            Integer n = holdTime = this.activeHand == null ? null : FirstAidRegistryImpl.INSTANCE.getPartHealingTime(this.field_230706_i_.field_71439_g.func_184586_b(this.activeHand));
            if (holdTime == null) {
                holdTime = Integer.MAX_VALUE;
            }
            ((GuiHoldButton)button2).setup(holdTime, (float)button2.func_230998_h_() / (float)HUDHandler.INSTANCE.getMaxLength());
            this.holdButtons.add((GuiHoldButton)button2);
        }
        super.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.func_238468_a_(stack, this.guiLeft, this.guiTop, this.guiLeft + 256, this.guiTop + 137, -16777216, -16777216);
        this.field_230706_i_.func_110434_K().func_110577_a(HealthRenderUtils.GUI_LOCATION);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, 256, 137);
        int entityLookX = this.guiLeft + 128 - mouseX;
        int entityLookY = this.guiTop + 20 - mouseY;
        if (EventCalendar.isGuiFun()) {
            entityLookX = -entityLookX;
            entityLookY = -entityLookY;
        }
        InventoryScreen.func_228187_a_((int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 30), (int)45, (float)entityLookX, (float)entityLookY, (LivingEntity)this.field_230706_i_.field_71439_g);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int morphineTicks = this.damageModel.getMorphineTicks();
        if (morphineTicks > 0) {
            GuiHealthScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"firstaid.gui.morphine_left", (Object[])new Object[]{StringUtils.func_76337_a((int)morphineTicks)}), (int)(this.guiLeft + 128), (int)(this.guiTop + 137 - (this.activeHand == null ? 21 : 29)), (int)0xFFFFFF);
        }
        if (this.activeHand != null) {
            GuiHealthScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"firstaid.gui.apply_hint", (Object[])new Object[0]), (int)(this.guiLeft + 128), (int)(this.guiTop + 137 - (morphineTicks == 0 ? 21 : 11)), (int)0xFFFFFF);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawHealth(stack, this.damageModel.HEAD, false, 14);
        this.drawHealth(stack, this.damageModel.LEFT_ARM, false, 39);
        this.drawHealth(stack, this.damageModel.LEFT_LEG, false, 64);
        this.drawHealth(stack, this.damageModel.LEFT_FOOT, false, 89);
        this.drawHealth(stack, this.damageModel.BODY, true, 14);
        this.drawHealth(stack, this.damageModel.RIGHT_ARM, true, 39);
        this.drawHealth(stack, this.damageModel.RIGHT_LEG, true, 64);
        this.drawHealth(stack, this.damageModel.RIGHT_FOOT, true, 89);
        stack.func_227860_a_();
        this.tooltipButton(stack, this.head, this.damageModel.HEAD, mouseX, mouseY);
        this.tooltipButton(stack, this.leftArm, this.damageModel.LEFT_ARM, mouseX, mouseY);
        this.tooltipButton(stack, this.leftLeg, this.damageModel.LEFT_LEG, mouseX, mouseY);
        this.tooltipButton(stack, this.leftFoot, this.damageModel.LEFT_FOOT, mouseX, mouseY);
        this.tooltipButton(stack, this.body, this.damageModel.BODY, mouseX, mouseY);
        this.tooltipButton(stack, this.rightArm, this.damageModel.RIGHT_ARM, mouseX, mouseY);
        this.tooltipButton(stack, this.rightLeg, this.damageModel.RIGHT_LEG, mouseX, mouseY);
        this.tooltipButton(stack, this.rightFoot, this.damageModel.RIGHT_FOOT, mouseX, mouseY);
        stack.func_227865_b_();
        double sleepHealing = (Double)FirstAidConfig.SERVER.sleepHealPercentage.get();
        int renderBedX = Math.round((float)this.guiLeft / this.bedScaleFactor) + 2;
        int renderBedY = Math.round((float)(this.guiTop + 137) / this.bedScaleFactor) - 18;
        int bedX = (int)((float)renderBedX * this.bedScaleFactor);
        int bedY = (int)((float)renderBedY * this.bedScaleFactor);
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)this.bedScaleFactor, (float)this.bedScaleFactor, (float)this.bedScaleFactor);
        this.field_230706_i_.func_175599_af().func_184391_a(null, BED_ITEMSTACK, renderBedX, renderBedY);
        RenderSystem.popMatrix();
        if (mouseX >= bedX && mouseY >= bedY && (float)mouseX < (float)bedX + 16.0f * this.bedScaleFactor && (float)mouseY < (float)bedY + 16.0f * this.bedScaleFactor) {
            TranslationTextComponent s = sleepHealing == 0.0 ? new TranslationTextComponent("firstaid.gui.no_sleep_heal") : new TranslationTextComponent("firstaid.gui.sleep_heal_amount", new Object[]{FORMAT.format(sleepHealing * 100.0)});
            this.func_238652_a_(stack, (ITextComponent)s, mouseX, mouseY);
            RenderSystem.disableLighting();
        }
        this.holdButtonMouseCallback(stack);
    }

    private void tooltipButton(MatrixStack stack, AbstractButton button, AbstractDamageablePart part, int mouseX, int mouseY) {
        boolean enabled;
        boolean bl = enabled = part.activeHealer == null;
        if (!enabled && button.func_230449_g_()) {
            this.func_243308_b(stack, Arrays.asList(new StringTextComponent(I18n.func_135052_a((String)"firstaid.gui.active_item", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)part.activeHealer.stack.func_77977_a(), (Object[])new Object[0])), new TranslationTextComponent("firstaid.gui.next_heal", new Object[]{Math.round((float)(part.activeHealer.ticksPerHeal.getAsInt() - part.activeHealer.getTicksPassed()) / 20.0f)})), mouseX, mouseY);
        }
        if (!this.disableButtons) {
            button.field_230693_o_ = enabled;
        }
    }

    public void drawHealth(MatrixStack stack, AbstractDamageablePart damageablePart, boolean right, int yOffset) {
        stack.func_227860_a_();
        int xTranslation = this.guiLeft + (right ? GuiHealthScreen.getRightOffset(damageablePart) : 57);
        HealthRenderUtils.drawHealth(stack, damageablePart, xTranslation, this.guiTop + yOffset, (AbstractGui)this, true);
        stack.func_227865_b_();
    }

    private static int getRightOffset(AbstractDamageablePart damageablePart) {
        if (HealthRenderUtils.drawAsString(damageablePart, true)) {
            return 160;
        }
        return 200 - Math.min(40, HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth()) * 9 + HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption()) * 9 + 2);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (ClientHooks.SHOW_WOUNDS.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.holdButtonMouseCallback(null);
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public void func_212927_b(double xPos, double yPos) {
        for (GuiHoldButton holdButton : this.holdButtons) {
            holdButton.func_212927_b(xPos, yPos);
        }
    }

    protected void holdButtonMouseCallback(MatrixStack stack) {
        for (GuiHoldButton button : this.holdButtons) {
            int timeLeft = button.getTimeLeft();
            if (timeLeft == 0) {
                button.reset();
                EnumPlayerPart playerPart = EnumPlayerPart.VALUES[button.id - 1];
                FirstAid.NETWORKING.sendToServer((Object)new MessageApplyHealingItem(playerPart, this.activeHand));
                AbstractDamageablePart part = this.damageModel.getFromEnum(playerPart);
                part.activeHealer = FirstAidRegistryImpl.INSTANCE.getPartHealer(this.field_230706_i_.field_71439_g.func_184586_b(this.activeHand));
                this.func_231175_as__();
                continue;
            }
            if (stack == null) {
                button.reset();
                continue;
            }
            if (timeLeft == -1) continue;
            float timeInSecs = (float)timeLeft / 1000.0f;
            if (timeInSecs < 0.0f) {
                timeInSecs = 0.0f;
            }
            this.field_230706_i_.func_110434_K().func_110577_a(HealthRenderUtils.GUI_LOCATION);
            this.func_238474_b_(stack, button.field_230690_l_ + (button.isRightSide ? 56 : -25), button.field_230691_m_ - 2, button.isRightSide ? 2 : 0, 169, 22, 24);
            this.field_230706_i_.field_71466_p.func_238421_b_(stack, HealthRenderUtils.TEXT_FORMAT.format(timeInSecs), (float)(button.field_230690_l_ + (button.isRightSide ? 60 : -20)), (float)(button.field_230691_m_ + 6), 0xFFFFFF);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_231175_as__() {
        INSTANCE = null;
        isOpen = false;
        super.func_231175_as__();
    }

    public List<Widget> getButtons() {
        return this.field_230710_m_;
    }

    static {
        isOpen = false;
    }
}

