/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.DirectDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DebugDamageCommand {
    private static final SimpleCommandExceptionType TYPE = new SimpleCommandExceptionType((Message)new StringTextComponent("0 is invalid as damage"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"damagePart").requires(source -> source.func_197034_c(2));
        ArrayList<EnumPlayerPart> allowedValues = new ArrayList<EnumPlayerPart>(Arrays.asList(EnumPlayerPart.VALUES));
        allowedValues.add(null);
        for (EnumPlayerPart part : allowedValues) {
            builder.then(Commands.func_197057_a((String)(part == null ? "ALL" : part.name())).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"damage", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> DebugDamageCommand.handleCommand(part, FloatArgumentType.getFloat((CommandContext)context, (String)"damage"), true, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197057_a((String)"nodebuff").executes(context -> DebugDamageCommand.handleCommand(part, FloatArgumentType.getFloat((CommandContext)context, (String)"damage"), false, ((CommandSource)context.getSource()).func_197035_h())))));
        }
        dispatcher.register(builder);
    }

    private static int handleCommand(EnumPlayerPart part, float damage, boolean debuff, ServerPlayerEntity player) throws CommandSyntaxException {
        if (damage == 0.0f) {
            throw TYPE.create();
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((PlayerEntity)player);
        if (part == null) {
            for (EnumPlayerPart aPart : EnumPlayerPart.VALUES) {
                DebugDamageCommand.doDamage(aPart, damage, debuff, player, damageModel);
            }
        } else {
            DebugDamageCommand.doDamage(part, damage, debuff, player, damageModel);
        }
        FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSyncDamageModel(damageModel, false));
        return 1;
    }

    private static void doDamage(EnumPlayerPart part, float damage, boolean debuff, ServerPlayerEntity player, AbstractPlayerDamageModel damageModel) {
        if (damage > 0.0f) {
            DamageDistribution.handleDamageTaken(new DirectDamageDistribution(part, debuff), damageModel, damage, (PlayerEntity)player, DamageSource.field_76380_i, false, false);
        } else {
            damageModel.getFromEnum(part).heal(-damage, (PlayerEntity)player, debuff);
        }
        if (damageModel.isDead((PlayerEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("death.attack.generic", new Object[]{player.func_145748_c_()}), Util.field_240973_b_);
            CommonUtils.killPlayer(damageModel, (PlayerEntity)player, null);
        }
    }
}

