/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.debuff.builder.IDebuffBuilder;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.SoundEvent;

public class DebuffBuilder
implements IDebuffBuilder {
    @Nonnull
    public final String potionName;
    @Nonnull
    public final Float2IntLinkedOpenHashMap map = new Float2IntLinkedOpenHashMap();
    public final boolean isOnHit;
    @Nullable
    public Supplier<SoundEvent> sound;
    @Nullable
    public BooleanSupplier isEnabledSupplier;

    public DebuffBuilder(@Nonnull String potionName, boolean isOnHit) {
        this.potionName = Objects.requireNonNull(potionName);
        this.isOnHit = isOnHit;
    }

    @Override
    @Nonnull
    public DebuffBuilder addSoundEffect(@Nullable Supplier<SoundEvent> event) {
        this.sound = event;
        return this;
    }

    @Override
    @Nonnull
    public DebuffBuilder addBound(float value, int multiplier) {
        this.map.put(value, multiplier);
        return this;
    }

    @Override
    @Nonnull
    public DebuffBuilder addEnableCondition(@Nullable BooleanSupplier isEnabled) {
        this.isEnabledSupplier = isEnabled;
        return this;
    }

    @Override
    public void register(@Nonnull EnumDebuffSlot slot) {
        Objects.requireNonNull(FirstAidRegistry.getImpl()).registerDebuff(slot, this);
    }
}

