/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class EqualDamageDistribution
implements IDamageDistribution {
    private static final Method applyPotionDamageCalculationsMethod = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70672_c", (Class[])new Class[]{DamageSource.class, Float.TYPE});
    private final boolean tryNoKill;
    private final float reductionMultiplier;

    public EqualDamageDistribution(boolean tryNoKill, float reductionMultiplier) {
        this.tryNoKill = tryNoKill;
        this.reductionMultiplier = reductionMultiplier;
    }

    private float reduceDamage(float originalDamage, PlayerEntity player, DamageSource source) {
        float damage = originalDamage;
        for (EquipmentSlotType slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack armor = player.func_184582_a(slot);
            damage = ArmorUtils.applyArmor(player, armor, source, damage, slot);
            if (!(damage <= 0.0f)) continue;
            return 0.0f;
        }
        try {
            damage = ((Float)applyPotionDamageCalculationsMethod.invoke((Object)player, source, Float.valueOf(damage))).floatValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            FirstAid.LOGGER.error("Could not invoke applyPotionDamageCalculations!", (Throwable)e);
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        float reduction = originalDamage - damage;
        if (reduction > 0.0f) {
            reduction *= this.reductionMultiplier;
        }
        if ((damage = originalDamage - reduction) <= 0.0f) {
            return 0.0f;
        }
        damage = ForgeHooks.onLivingDamage((LivingEntity)player, (DamageSource)source, (float)damage);
        return damage;
    }

    private float distributeOnParts(float damage, AbstractPlayerDamageModel damageModel, PlayerEntity player, boolean tryNoKillThisRound) {
        float prevDamageLeft;
        int iterationCounter = 0;
        int divCount = EnumPlayerPart.VALUES.length;
        float damageLeft = damage;
        do {
            prevDamageLeft = damageLeft;
            float toDamage = damageLeft / (float)divCount;
            divCount = 0;
            damageLeft = 0.0f;
            for (AbstractDamageablePart part : damageModel) {
                if (!(part.currentHealth > 0.0f)) continue;
                damageLeft += part.damage(toDamage, player, !player.func_70644_a(EventHandler.MORPHINE), tryNoKillThisRound ? 1.0f : 0.0f);
                ++divCount;
            }
            if (iterationCounter >= 50) {
                FirstAid.LOGGER.warn("Not done distribution equally after 50 rounds, diff {}. Dropping!", (Object)Float.valueOf(Math.abs(prevDamageLeft - damageLeft)));
                break;
            }
            ++iterationCounter;
        } while (prevDamageLeft != damageLeft);
        return damageLeft;
    }

    @Override
    public float distributeDamage(float damage, @Nonnull PlayerEntity player, @Nonnull DamageSource source, boolean addStat) {
        if ((damage = this.reduceDamage(damage, player, source)) <= 0.0f) {
            return 0.0f;
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        Objects.requireNonNull(damageModel);
        float damageLeft = this.distributeOnParts(damage, damageModel, player, this.tryNoKill);
        if (damageLeft > 0.0f && this.tryNoKill) {
            damageLeft = this.distributeOnParts(damage, damageModel, player, false);
        }
        FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageSyncDamageModel(damageModel, false));
        float effectiveDmg = damage - damageLeft;
        if (effectiveDmg < 3.4028235E37f) {
            player.func_195067_a(Stats.field_188112_z, Math.round(effectiveDmg * 10.0f));
        }
        return damageLeft;
    }

    @Override
    public boolean skipGlobalPotionModifiers() {
        return true;
    }
}

