/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageConfiguration {
    private final CompoundNBT playerDamageModel;

    public MessageConfiguration(CompoundNBT model) {
        this.playerDamageModel = model;
    }

    public MessageConfiguration(PacketBuffer buffer) {
        this(buffer.func_150793_b());
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.playerDamageModel);
    }

    public static class Handler {
        public static void onMessage(MessageConfiguration message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            FirstAid.LOGGER.info("Received remote damage model");
            ctx.enqueueWork(() -> {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                damageModel.deserializeNBT((INBT)message.playerDamageModel);
                if (damageModel.hasTutorial) {
                    CapProvider.tutorialDone.add(Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString());
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("[First Aid] " + I18n.func_135052_a((String)"firstaid.tutorial.hint", (Object[])new Object[]{ClientHooks.SHOW_WOUNDS.func_238171_j_().getString()})), Util.field_240973_b_);
                }
                HUDHandler.INSTANCE.ticker = 200;
                FirstAid.isSynced = true;
            });
        }
    }
}

