/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncDamageModel {
    private final CompoundNBT playerDamageModel;
    private final boolean scaleMaxHealth;

    public MessageSyncDamageModel(PacketBuffer buffer) {
        this.playerDamageModel = buffer.func_150793_b();
        this.scaleMaxHealth = buffer.readBoolean();
    }

    public MessageSyncDamageModel(AbstractPlayerDamageModel damageModel, boolean scaleMaxHealth) {
        this.playerDamageModel = (CompoundNBT)damageModel.serializeNBT();
        this.scaleMaxHealth = scaleMaxHealth;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150786_a(this.playerDamageModel);
        buffer.writeBoolean(this.scaleMaxHealth);
    }

    public static final class Handler {
        public static void onMessage(MessageSyncDamageModel message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((PlayerEntity)mc.field_71439_g);
                if (message.scaleMaxHealth) {
                    damageModel.runScaleLogic((PlayerEntity)mc.field_71439_g);
                }
                damageModel.deserializeNBT((INBT)message.playerDamageModel);
            });
        }
    }
}

