/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.collect.Iterators;
import com.google.common.math.DoubleMath;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.util.CommonUtils;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;

public class ArmorUtils {
    public static double getArmor(ItemStack stack, EquipmentSlotType slot) {
        return ArmorUtils.getValueFromAttributes(Attributes.field_233826_i_, slot, stack);
    }

    public static double getArmorThoughness(ItemStack stack, EquipmentSlotType slot) {
        return ArmorUtils.getValueFromAttributes(Attributes.field_233827_j_, slot, stack);
    }

    public static double applyArmorModifier(EquipmentSlotType slot, double rawArmor) {
        if (rawArmor <= 0.0) {
            return 0.0;
        }
        rawArmor *= (double)ArmorUtils.getArmorModifier(slot);
        if (slot == EquipmentSlotType.HEAD) {
            rawArmor += 1.0;
        }
        return rawArmor;
    }

    public static double applyToughnessModifier(EquipmentSlotType slot, double rawToughness) {
        if (rawToughness <= 0.0) {
            return 0.0;
        }
        return rawToughness *= (double)ArmorUtils.getToughnessModifier(slot);
    }

    private static float getArmorModifier(EquipmentSlotType slot) {
        switch (slot) {
            case CHEST: {
                return 2.5f;
            }
            case LEGS: {
                return 3.0f;
            }
            case FEET: 
            case HEAD: {
                return 6.0f;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static float getToughnessModifier(EquipmentSlotType slot) {
        switch (slot) {
            case CHEST: 
            case LEGS: {
                return 3.0f;
            }
            case FEET: {
                return 3.5f;
            }
            case HEAD: {
                return 4.0f;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getValueFromAttributes(Attribute attribute, EquipmentSlotType slot, ItemStack stack) {
        return stack.func_77973_b().getAttributeModifiers(slot, stack).get((Object)attribute).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
    }

    private static double getGlobalRestAttribute(PlayerEntity player, Attribute attribute) {
        double sumOfAllAttributes = 0.0;
        for (EquipmentSlotType slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack otherStack = player.func_184582_a(slot);
            sumOfAllAttributes += ArmorUtils.getValueFromAttributes(attribute, slot, otherStack);
        }
        double all = player.func_233637_b_(attribute);
        if (!DoubleMath.fuzzyEquals((double)sumOfAllAttributes, (double)all, (double)0.001)) {
            double diff = all - sumOfAllAttributes;
            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                FirstAid.LOGGER.info("Attribute value for {} does not match sum! Diff is {}, distributing to all!", (Object)attribute.getRegistryName(), (Object)diff);
            }
            return diff;
        }
        return 0.0;
    }

    public static float applyArmor(@Nonnull PlayerEntity entity, @Nonnull ItemStack itemStack, @Nonnull DamageSource source, float damage, @Nonnull EquipmentSlotType slot) {
        if (source.func_76363_c()) {
            return damage;
        }
        Item item = itemStack.func_77973_b();
        float totalArmor = 0.0f;
        float totalToughness = 0.0f;
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            totalArmor = armor.func_200881_e();
            totalToughness = armor.func_234657_f_();
            totalArmor = (float)ArmorUtils.applyArmorModifier(slot, totalArmor);
            totalToughness = (float)ArmorUtils.applyToughnessModifier(slot, totalToughness);
        }
        totalArmor = (float)((double)totalArmor + ArmorUtils.getGlobalRestAttribute(entity, Attributes.field_233826_i_));
        totalToughness = (float)((double)totalToughness + ArmorUtils.getGlobalRestAttribute(entity, Attributes.field_233827_j_));
        if (damage > 0.0f && (totalArmor > 0.0f || totalToughness > 0.0f)) {
            if (!(!(item instanceof ArmorItem) || source.func_76347_k() && item.func_234687_u_())) {
                int itemDamage = Math.max((int)damage, 1);
                itemStack.func_222118_a(itemDamage, (LivingEntity)entity, player -> player.func_213361_c(slot));
            }
            damage = CombatRules.func_189427_a((float)damage, (float)totalArmor, (float)totalToughness);
        }
        return damage;
    }

    public static float applyGlobalPotionModifiers(PlayerEntity player, DamageSource source, float damage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(Effects.field_76429_m) && source != DamageSource.field_76380_i && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (i = (player.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (player instanceof ServerPlayerEntity) {
                player.func_195067_a(Stats.field_212739_K, Math.round(f2 * 10.0f));
            } else if (source.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)source.func_76346_g()).func_195067_a(Stats.field_212736_G, Math.round(f2 * 10.0f));
            }
        }
        return damage;
    }

    public static float applyEnchantmentModifiers(PlayerEntity player, EquipmentSlotType slot, DamageSource source, float damage) {
        int k;
        if (source.func_76363_c()) {
            return damage;
        }
        FirstAidConfig.Server.ArmorEnchantmentMode enchantmentMode = (FirstAidConfig.Server.ArmorEnchantmentMode)((Object)FirstAidConfig.SERVER.armorEnchantmentMode.get());
        if (enchantmentMode == FirstAidConfig.Server.ArmorEnchantmentMode.LOCAL_ENCHANTMENTS) {
            k = EnchantmentHelper.func_77508_a(() -> Iterators.singletonIterator((Object)player.func_184582_a(slot)), (DamageSource)source);
            k *= 4;
        } else if (enchantmentMode == FirstAidConfig.Server.ArmorEnchantmentMode.GLOBAL_ENCHANTMENTS) {
            k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)source);
        } else {
            throw new RuntimeException("What dark magic is " + (Object)((Object)enchantmentMode));
        }
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

